/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.gson.configuration.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.time.DayOfWeek;

public class DayOfWeekDeserializer
implements JsonDeserializer<DayOfWeek> {
    public static final DayOfWeekDeserializer INSTANCE = new DayOfWeekDeserializer();
    private static final DayOfWeek[] DAY_OF_WEEKS = DayOfWeek.values();

    public DayOfWeek deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            if (json instanceof JsonPrimitive) {
                if (((JsonPrimitive)json).isNumber()) {
                    return DayOfWeek.of(json.getAsInt());
                }
                String valueAsJson = json.getAsString();
                for (DayOfWeek dayOfWeek : DAY_OF_WEEKS) {
                    if (!dayOfWeek.name().equalsIgnoreCase(valueAsJson)) continue;
                    return dayOfWeek;
                }
                return DayOfWeek.of(Integer.parseInt(json.getAsString()));
            }
        }
        catch (Exception e) {
            throw new JsonParseException((Throwable)e);
        }
        throw new JsonParseException("DayOfWeek can not be parsed from: " + json.getAsString());
    }
}

