/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.gson.configuration.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import io.goodforgod.gson.configuration.deserializer.DateTimeDeserializerFormatters;
import java.lang.reflect.Type;
import java.time.MonthDay;
import java.time.format.DateTimeFormatter;

public class MonthDayDeserializer
implements JsonDeserializer<MonthDay> {
    public static final MonthDayDeserializer INSTANCE = new MonthDayDeserializer();
    private final DateTimeFormatter formatter;

    public MonthDayDeserializer() {
        this(DateTimeDeserializerFormatters.ISO_MONTH_DAY);
    }

    public MonthDayDeserializer(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public MonthDay deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            if (json instanceof JsonPrimitive) {
                String monthAsJson = json.getAsString();
                return this.formatter.parse(monthAsJson).query(MonthDay::from);
            }
        }
        catch (Exception e) {
            throw new JsonParseException((Throwable)e);
        }
        throw new JsonParseException("MonthDay can not be parsed from: " + json.getAsString());
    }
}

