/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.gson.configuration.deserializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.time.Month;

public class MonthDeserializer
implements JsonDeserializer<Month> {
    public static final MonthDeserializer INSTANCE = new MonthDeserializer();
    private static final Month[] MONTHS = Month.values();

    public Month deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            if (json instanceof JsonPrimitive) {
                if (((JsonPrimitive)json).isNumber()) {
                    return Month.of(json.getAsInt());
                }
                String monthAsJson = json.getAsString();
                for (Month month : MONTHS) {
                    if (!month.name().equalsIgnoreCase(monthAsJson)) continue;
                    return month;
                }
                return Month.of(Integer.parseInt(json.getAsString()));
            }
        }
        catch (Exception e) {
            throw new JsonParseException((Throwable)e);
        }
        throw new JsonParseException("Month can not be parsed from: " + json.getAsString());
    }
}

