/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.gson.configuration.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.goodforgod.gson.configuration.serializer.DateTimeSerializerFormatters;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class LocalDateSerializer
implements JsonSerializer<LocalDate> {
    public static final LocalDateSerializer INSTANCE = new LocalDateSerializer();
    private final DateTimeFormatter formatter;

    public LocalDateSerializer() {
        this(DateTimeSerializerFormatters.ISO_LOCAL_DATE);
    }

    public LocalDateSerializer(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public JsonElement serialize(LocalDate src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(this.formatter.format(src));
    }
}

