/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.gson.configuration.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.goodforgod.gson.configuration.serializer.DateTimeSerializerFormatters;
import java.lang.reflect.Type;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class LocalTimeSerializer
implements JsonSerializer<LocalTime> {
    public static final LocalTimeSerializer INSTANCE = new LocalTimeSerializer();
    private final DateTimeFormatter formatter;

    public LocalTimeSerializer() {
        this(DateTimeSerializerFormatters.ISO_LOCAL_TIME);
    }

    public LocalTimeSerializer(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public JsonElement serialize(LocalTime src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(this.formatter.format(src));
    }
}

