/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.gson.configuration.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import io.goodforgod.gson.configuration.serializer.DateTimeSerializerFormatters;
import java.lang.reflect.Type;
import java.time.MonthDay;
import java.time.format.DateTimeFormatter;

public class MonthDaySerializer
implements JsonSerializer<MonthDay> {
    public static final MonthDaySerializer INSTANCE = new MonthDaySerializer();
    private final DateTimeFormatter formatter;

    public MonthDaySerializer() {
        this(DateTimeSerializerFormatters.ISO_MONTH_DAY);
    }

    public MonthDaySerializer(DateTimeFormatter formatter) {
        this.formatter = formatter;
    }

    public JsonElement serialize(MonthDay src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(this.formatter.format(src));
    }
}

