/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.jackson.module.datetime.configuration;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.ValueInstantiators;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.PackageVersion;
import com.fasterxml.jackson.datatype.jsr310.deser.DurationDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.InstantDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.JSR310StringParsableDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.MonthDayDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.OffsetTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.YearDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.YearMonthDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.DurationKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.InstantKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.LocalDateKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.LocalDateTimeKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.LocalTimeKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.MonthDayKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.OffsetDateTimeKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.OffsetTimeKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.PeriodKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.YearKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.YearMonthKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.ZoneIdKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.ZoneOffsetKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.key.ZonedDateTimeKeyDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.DurationSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.InstantSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.MonthDaySerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.OffsetDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.OffsetTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.YearMonthSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.YearSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.ZonedDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.key.ZonedDateTimeKeySerializer;
import io.goodforgod.jackson.module.datetime.configuration.DateTimeFormatters;
import io.goodforgod.jackson.module.datetime.configuration.deserializer.Deserializers;
import io.goodforgod.jackson.module.datetime.configuration.deserializer.InstantISODeserializer;
import io.goodforgod.jackson.module.datetime.configuration.deserializer.OffsetTimeISODeserializer;
import io.goodforgod.jackson.module.datetime.configuration.serializer.InstantISOSerializer;
import io.goodforgod.jackson.module.datetime.configuration.serializer.OffsetDateTimeISOSerializer;
import io.goodforgod.jackson.module.datetime.configuration.serializer.OffsetTimeISOSerializer;
import io.goodforgod.jackson.module.datetime.configuration.serializer.Serializers;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

public class JavaTimeModule
extends SimpleModule {
    public JavaTimeModule(DateTimeFormatter instantFormat, DateTimeFormatter offsetTimeFormat, DateTimeFormatter offsetDateTimeFormat, DateTimeFormatter zonedDateTimeFormat, DateTimeFormatter localDateTimeFormat, DateTimeFormatter localDateFormat, DateTimeFormatter localTimeFormat, DateTimeFormatter yearFormat, DateTimeFormatter yearMonthFormat, DateTimeFormatter monthDayFormat) {
        super(PackageVersion.VERSION);
        InstantDeserializer<Instant> instantDeserializer = this.getInstantDeserializer(instantFormat);
        OffsetTimeDeserializer offsetTimeDeserializer = this.getOffsetTimeDeserializer(offsetTimeFormat);
        InstantDeserializer<OffsetDateTime> offsetDateTimeDeserializer = this.getOffsetDateTimeDeserializer(offsetDateTimeFormat);
        InstantDeserializer<ZonedDateTime> zonedDateTimeDeserializer = this.getZonedDateTimeDeserializer(zonedDateTimeFormat);
        LocalDateTimeDeserializer localDateTimeDeserializer = this.getLocalDateTimeDeserializer(localDateTimeFormat);
        LocalDateDeserializer localDateDeserializer = this.getLocalDateDeserializer(localDateFormat);
        LocalTimeDeserializer localTimeDeserializer = this.getLocalTimeDeserializer(localTimeFormat);
        YearDeserializer yearDeserializer = this.getYearDeserializer(yearFormat);
        YearMonthDeserializer yearMonthDeserializer = this.getYearMonthDeserializer(yearMonthFormat);
        MonthDayDeserializer monthDayDeserializer = this.getMonthDayDeserializer(monthDayFormat);
        this.addDeserializer(Instant.class, (JsonDeserializer)instantDeserializer);
        this.addDeserializer(OffsetDateTime.class, (JsonDeserializer)offsetDateTimeDeserializer);
        this.addDeserializer(ZonedDateTime.class, (JsonDeserializer)zonedDateTimeDeserializer);
        this.addDeserializer(OffsetTime.class, (JsonDeserializer)offsetTimeDeserializer);
        this.addDeserializer(LocalDateTime.class, (JsonDeserializer)localDateTimeDeserializer);
        this.addDeserializer(LocalDate.class, (JsonDeserializer)localDateDeserializer);
        this.addDeserializer(LocalTime.class, (JsonDeserializer)localTimeDeserializer);
        this.addDeserializer(Year.class, (JsonDeserializer)yearDeserializer);
        this.addDeserializer(YearMonth.class, (JsonDeserializer)yearMonthDeserializer);
        this.addDeserializer(MonthDay.class, (JsonDeserializer)monthDayDeserializer);
        this.addDeserializer(Period.class, JSR310StringParsableDeserializer.PERIOD);
        this.addDeserializer(Duration.class, (JsonDeserializer)DurationDeserializer.INSTANCE);
        this.addDeserializer(ZoneId.class, JSR310StringParsableDeserializer.ZONE_ID);
        this.addDeserializer(ZoneOffset.class, JSR310StringParsableDeserializer.ZONE_OFFSET);
        InstantSerializer instantSerializer = this.getInstantSerializer(instantFormat);
        OffsetTimeSerializer offsetTimeSerializer = this.getOffsetTimeSerializer(offsetTimeFormat);
        OffsetDateTimeSerializer offsetDateTimeSerializer = this.getOffsetDateTimeSerializer(offsetDateTimeFormat);
        ZonedDateTimeSerializer zonedDateTimeSerializer = this.getZonedDateTimeSerializer(zonedDateTimeFormat);
        LocalDateTimeSerializer localDateTimeSerializer = this.getLocalDateTimeSerializer(localDateTimeFormat);
        LocalDateSerializer localDateSerializer = this.getLocalDateSerializer(localDateFormat);
        LocalTimeSerializer localTimeSerializer = this.getLocalTimeSerializer(localTimeFormat);
        YearSerializer yearSerializer = this.getYearSerializer(yearFormat);
        YearMonthSerializer yearMonthSerializer = this.getYearMonthSerializer(yearMonthFormat);
        MonthDaySerializer monthDaySerializer = this.getMonthDaySerializer(monthDayFormat);
        this.addSerializer(Instant.class, (JsonSerializer)instantSerializer);
        this.addSerializer(OffsetDateTime.class, (JsonSerializer)offsetDateTimeSerializer);
        this.addSerializer(ZonedDateTime.class, (JsonSerializer)zonedDateTimeSerializer);
        this.addSerializer(OffsetTime.class, (JsonSerializer)offsetTimeSerializer);
        this.addSerializer(LocalDateTime.class, (JsonSerializer)localDateTimeSerializer);
        this.addSerializer(LocalDate.class, (JsonSerializer)localDateSerializer);
        this.addSerializer(LocalTime.class, (JsonSerializer)localTimeSerializer);
        this.addSerializer(Year.class, (JsonSerializer)yearSerializer);
        this.addSerializer(YearMonth.class, (JsonSerializer)yearMonthSerializer);
        this.addSerializer(MonthDay.class, (JsonSerializer)monthDaySerializer);
        this.addSerializer(Period.class, (JsonSerializer)Serializers.PERIOD);
        this.addSerializer(Duration.class, (JsonSerializer)DurationSerializer.INSTANCE);
        this.addSerializer(ZoneId.class, (JsonSerializer)Serializers.ZONE_ID);
        this.addSerializer(ZoneOffset.class, (JsonSerializer)Serializers.ZONE_OFFSET);
        this.addKeySerializer(ZonedDateTime.class, (JsonSerializer)ZonedDateTimeKeySerializer.INSTANCE);
        this.addKeyDeserializer(ZonedDateTime.class, (KeyDeserializer)ZonedDateTimeKeyDeserializer.INSTANCE);
        this.addKeyDeserializer(LocalDateTime.class, (KeyDeserializer)LocalDateTimeKeyDeserializer.INSTANCE);
        this.addKeyDeserializer(LocalDate.class, (KeyDeserializer)LocalDateKeyDeserializer.INSTANCE);
        this.addKeyDeserializer(LocalTime.class, (KeyDeserializer)LocalTimeKeyDeserializer.INSTANCE);
        this.addKeyDeserializer(OffsetDateTime.class, (KeyDeserializer)OffsetDateTimeKeyDeserializer.INSTANCE);
        this.addKeyDeserializer(OffsetTime.class, (KeyDeserializer)OffsetTimeKeyDeserializer.INSTANCE);
        this.addKeyDeserializer(Duration.class, (KeyDeserializer)DurationKeyDeserializer.INSTANCE);
        this.addKeyDeserializer(Instant.class, (KeyDeserializer)InstantKeyDeserializer.INSTANCE);
        this.addKeyDeserializer(MonthDay.class, (KeyDeserializer)MonthDayKeyDeserializer.INSTANCE);
        this.addKeyDeserializer(Period.class, (KeyDeserializer)PeriodKeyDeserializer.INSTANCE);
        this.addKeyDeserializer(Year.class, (KeyDeserializer)YearKeyDeserializer.INSTANCE);
        this.addKeyDeserializer(YearMonth.class, (KeyDeserializer)YearMonthKeyDeserializer.INSTANCE);
        this.addKeyDeserializer(ZoneId.class, (KeyDeserializer)ZoneIdKeyDeserializer.INSTANCE);
        this.addKeyDeserializer(ZoneOffset.class, (KeyDeserializer)ZoneOffsetKeyDeserializer.INSTANCE);
    }

    protected InstantDeserializer<Instant> getInstantDeserializer(DateTimeFormatter formatter) {
        if (DateTimeFormatter.ISO_INSTANT == formatter) {
            return InstantDeserializer.INSTANT;
        }
        return new InstantISODeserializer<Instant>(InstantDeserializer.INSTANT, formatter);
    }

    protected InstantDeserializer<OffsetDateTime> getOffsetDateTimeDeserializer(DateTimeFormatter formatter) {
        if (DateTimeFormatter.ISO_OFFSET_DATE_TIME == formatter) {
            return Deserializers.JAVA_ISO_OFFSET_DATE_TIME;
        }
        if (DateTimeFormatters.ISO_OFFSET_DATE_TIME == formatter) {
            return Deserializers.OFFSET_DATE_TIME;
        }
        return new InstantISODeserializer<OffsetDateTime>(InstantDeserializer.OFFSET_DATE_TIME, formatter);
    }

    protected InstantDeserializer<ZonedDateTime> getZonedDateTimeDeserializer(DateTimeFormatter formatter) {
        if (DateTimeFormatter.ISO_ZONED_DATE_TIME == formatter) {
            return Deserializers.JAVA_ISO_ZONED_DATE_TIME;
        }
        if (DateTimeFormatters.ISO_ZONED_DATE_TIME == formatter) {
            return Deserializers.ZONED_DATE_TIME;
        }
        return new InstantISODeserializer<ZonedDateTime>(InstantDeserializer.ZONED_DATE_TIME, formatter);
    }

    protected OffsetTimeDeserializer getOffsetTimeDeserializer(DateTimeFormatter formatter) {
        if (DateTimeFormatter.ISO_OFFSET_TIME == formatter) {
            return OffsetTimeDeserializer.INSTANCE;
        }
        if (DateTimeFormatters.ISO_OFFSET_TIME == formatter) {
            return Deserializers.OFFSET_TIME;
        }
        return new OffsetTimeISODeserializer(formatter);
    }

    protected LocalDateTimeDeserializer getLocalDateTimeDeserializer(DateTimeFormatter formatter) {
        if (DateTimeFormatter.ISO_LOCAL_DATE_TIME == formatter) {
            return LocalDateTimeDeserializer.INSTANCE;
        }
        if (DateTimeFormatters.ISO_LOCAL_DATE_TIME == formatter) {
            return Deserializers.LOCAL_DATE_TIME;
        }
        return new LocalDateTimeDeserializer(formatter);
    }

    protected LocalDateDeserializer getLocalDateDeserializer(DateTimeFormatter formatter) {
        if (DateTimeFormatter.ISO_LOCAL_DATE == formatter) {
            return LocalDateDeserializer.INSTANCE;
        }
        if (DateTimeFormatters.ISO_LOCAL_DATE == formatter) {
            return Deserializers.LOCAL_DATE;
        }
        return new LocalDateDeserializer(formatter);
    }

    protected LocalTimeDeserializer getLocalTimeDeserializer(DateTimeFormatter formatter) {
        if (DateTimeFormatter.ISO_LOCAL_TIME == formatter) {
            return LocalTimeDeserializer.INSTANCE;
        }
        if (DateTimeFormatters.ISO_LOCAL_TIME == formatter) {
            return Deserializers.LOCAL_TIME;
        }
        return new LocalTimeDeserializer(formatter);
    }

    protected YearDeserializer getYearDeserializer(DateTimeFormatter formatter) {
        if (DateTimeFormatters.ISO_LOCAL_DATE_TIME == formatter) {
            return Deserializers.YEAR;
        }
        return new YearDeserializer(formatter);
    }

    protected YearMonthDeserializer getYearMonthDeserializer(DateTimeFormatter formatter) {
        if (DateTimeFormatters.ISO_LOCAL_DATE == formatter) {
            return Deserializers.YEAR_MONTH;
        }
        return new YearMonthDeserializer(formatter);
    }

    protected MonthDayDeserializer getMonthDayDeserializer(DateTimeFormatter formatter) {
        if (DateTimeFormatters.ISO_LOCAL_TIME == formatter) {
            return Deserializers.MONTH_DAY;
        }
        return new MonthDayDeserializer(formatter);
    }

    protected InstantSerializer getInstantSerializer(DateTimeFormatter formatter) {
        if (DateTimeFormatter.ISO_INSTANT == formatter) {
            return InstantSerializer.INSTANCE;
        }
        return new InstantISOSerializer(formatter);
    }

    protected OffsetDateTimeSerializer getOffsetDateTimeSerializer(DateTimeFormatter formatter) {
        if (DateTimeFormatter.ISO_OFFSET_DATE_TIME == formatter) {
            return OffsetDateTimeSerializer.INSTANCE;
        }
        if (DateTimeFormatters.ISO_OFFSET_DATE_TIME == formatter) {
            return Serializers.OFFSET_DATE_TIME;
        }
        return new OffsetDateTimeISOSerializer(formatter);
    }

    protected ZonedDateTimeSerializer getZonedDateTimeSerializer(DateTimeFormatter formatter) {
        if (DateTimeFormatter.ISO_ZONED_DATE_TIME == formatter) {
            return Serializers.JAVA_ISO_ZONED_DATE_TIME;
        }
        if (DateTimeFormatters.ISO_ZONED_DATE_TIME == formatter) {
            return Serializers.ZONED_DATE_TIME;
        }
        return new ZonedDateTimeSerializer(formatter);
    }

    protected OffsetTimeSerializer getOffsetTimeSerializer(DateTimeFormatter formatter) {
        if (DateTimeFormatter.ISO_OFFSET_TIME == formatter) {
            return Serializers.JAVA_ISO_OFFSET_TIME;
        }
        if (DateTimeFormatters.ISO_OFFSET_TIME == formatter) {
            return Serializers.OFFSET_TIME;
        }
        return new OffsetTimeISOSerializer(formatter);
    }

    protected LocalDateTimeSerializer getLocalDateTimeSerializer(DateTimeFormatter formatter) {
        if (DateTimeFormatter.ISO_LOCAL_DATE_TIME == formatter) {
            return LocalDateTimeSerializer.INSTANCE;
        }
        if (DateTimeFormatters.ISO_LOCAL_DATE_TIME == formatter) {
            return Serializers.LOCAL_DATE_TIME;
        }
        return new LocalDateTimeSerializer(formatter);
    }

    protected LocalDateSerializer getLocalDateSerializer(DateTimeFormatter formatter) {
        if (DateTimeFormatter.ISO_LOCAL_DATE == formatter) {
            return LocalDateSerializer.INSTANCE;
        }
        if (DateTimeFormatters.ISO_LOCAL_DATE == formatter) {
            return Serializers.LOCAL_DATE;
        }
        return new LocalDateSerializer(formatter);
    }

    protected LocalTimeSerializer getLocalTimeSerializer(DateTimeFormatter formatter) {
        if (DateTimeFormatter.ISO_LOCAL_TIME == formatter) {
            return LocalTimeSerializer.INSTANCE;
        }
        if (DateTimeFormatters.ISO_LOCAL_TIME == formatter) {
            return Serializers.LOCAL_TIME;
        }
        return new LocalTimeSerializer(formatter);
    }

    protected YearSerializer getYearSerializer(DateTimeFormatter formatter) {
        if (DateTimeFormatters.ISO_LOCAL_DATE_TIME == formatter) {
            return Serializers.YEAR;
        }
        return new YearSerializer(formatter);
    }

    protected YearMonthSerializer getYearMonthSerializer(DateTimeFormatter formatter) {
        if (DateTimeFormatters.ISO_LOCAL_DATE == formatter) {
            return Serializers.YEAR_MONTH;
        }
        return new YearMonthSerializer(formatter);
    }

    protected MonthDaySerializer getMonthDaySerializer(DateTimeFormatter formatter) {
        if (DateTimeFormatters.ISO_LOCAL_TIME == formatter) {
            return Serializers.MONTH_DAY;
        }
        return new MonthDaySerializer(formatter);
    }

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        context.addValueInstantiators((ValueInstantiators)new ValueInstantiators.Base(){

            public ValueInstantiator findValueInstantiator(DeserializationConfig config, BeanDescription beanDesc, ValueInstantiator defaultInstantiator) {
                return defaultInstantiator;
            }
        });
    }
}

