/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.jackson.module.datetime.configuration;

import io.goodforgod.jackson.module.datetime.configuration.DateTimeFormatters;
import io.goodforgod.jackson.module.datetime.configuration.JavaTimeModule;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeFormatter;
import java.time.format.ResolverStyle;

public class JavaTimeModuleConfiguration {
    private boolean forceResolverStrict = false;
    private boolean forceIsoChronology = false;
    private DateTimeFormatter instantFormat = DateTimeFormatters.ISO_INSTANT;
    private DateTimeFormatter offsetTimeFormat = DateTimeFormatters.ISO_OFFSET_TIME;
    private DateTimeFormatter offsetDateTimeFormat = DateTimeFormatters.ISO_OFFSET_DATE_TIME;
    private DateTimeFormatter zonedDateTimeFormat = DateTimeFormatters.ISO_ZONED_DATE_TIME;
    private DateTimeFormatter localDateTimeFormat = DateTimeFormatters.ISO_LOCAL_DATE_TIME;
    private DateTimeFormatter localDateFormat = DateTimeFormatters.ISO_LOCAL_DATE;
    private DateTimeFormatter localTimeFormat = DateTimeFormatters.ISO_LOCAL_TIME;
    private DateTimeFormatter yearFormat = DateTimeFormatters.ISO_YEAR;
    private DateTimeFormatter yearMonthFormat = DateTimeFormatters.ISO_YEAR_MONTH;
    private DateTimeFormatter monthDayFormat = DateTimeFormatters.ISO_MONTH_DAY;

    protected JavaTimeModuleConfiguration() {
    }

    public static JavaTimeModuleConfiguration ofISO() {
        return new JavaTimeModuleConfiguration();
    }

    public static JavaTimeModuleConfiguration ofJavaISO() {
        JavaTimeModuleConfiguration configuration = new JavaTimeModuleConfiguration();
        configuration.setInstantFormat(DateTimeFormatter.ISO_INSTANT);
        configuration.setOffsetTimeFormat(DateTimeFormatter.ISO_OFFSET_TIME);
        configuration.setOffsetDateTimeFormat(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        configuration.setZonedDateTimeFormat(DateTimeFormatter.ISO_ZONED_DATE_TIME);
        configuration.setLocalDateTimeFormat(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        configuration.setLocalDateFormat(DateTimeFormatter.ISO_LOCAL_DATE);
        configuration.setLocalTimeFormat(DateTimeFormatter.ISO_LOCAL_TIME);
        return configuration;
    }

    public JavaTimeModule getModule() {
        return new JavaTimeModule(this.getInstantFormat(), this.getOffsetTimeFormat(), this.getOffsetDateTimeFormat(), this.getZonedDateTimeFormat(), this.getLocalDateTimeFormat(), this.getLocalDateFormat(), this.getLocalTimeFormat(), this.getYearFormat(), this.getYearMonthFormat(), this.getMonthDayFormat());
    }

    public boolean isForceResolverStrict() {
        return this.forceResolverStrict;
    }

    public JavaTimeModuleConfiguration setForceResolverStrict(boolean forceResolverStrict) {
        this.forceResolverStrict = forceResolverStrict;
        return this;
    }

    public boolean isForceIsoChronology() {
        return this.forceIsoChronology;
    }

    public JavaTimeModuleConfiguration setForceIsoChronology(boolean forceIsoChronology) {
        this.forceIsoChronology = forceIsoChronology;
        return this;
    }

    public DateTimeFormatter getInstantFormat() {
        return this.instantFormat;
    }

    public JavaTimeModuleConfiguration setInstantFormat(DateTimeFormatter instantFormat) {
        this.instantFormat = this.applyRestrictions(instantFormat);
        return this;
    }

    public JavaTimeModuleConfiguration setInstantFormat(String instantPattern) {
        return this.setInstantFormat(DateTimeFormatter.ofPattern(instantPattern));
    }

    public DateTimeFormatter getLocalDateFormat() {
        return this.localDateFormat;
    }

    public JavaTimeModuleConfiguration setLocalDateFormat(DateTimeFormatter localDateFormat) {
        this.localDateFormat = this.applyRestrictions(localDateFormat);
        return this;
    }

    public JavaTimeModuleConfiguration setLocalDateFormat(String localDatePattern) {
        return this.setLocalDateFormat(DateTimeFormatter.ofPattern(localDatePattern));
    }

    public DateTimeFormatter getLocalTimeFormat() {
        return this.localTimeFormat;
    }

    public JavaTimeModuleConfiguration setLocalTimeFormat(DateTimeFormatter localTimeFormat) {
        this.localTimeFormat = this.applyRestrictions(localTimeFormat);
        return this;
    }

    public JavaTimeModuleConfiguration setLocalTimeFormat(String localTimePattern) {
        return this.setLocalTimeFormat(DateTimeFormatter.ofPattern(localTimePattern));
    }

    public DateTimeFormatter getLocalDateTimeFormat() {
        return this.localDateTimeFormat;
    }

    public JavaTimeModuleConfiguration setLocalDateTimeFormat(DateTimeFormatter localDateTimeFormat) {
        this.localDateTimeFormat = this.applyRestrictions(localDateTimeFormat);
        return this;
    }

    public JavaTimeModuleConfiguration setLocalDateTimeFormat(String localDateTimePattern) {
        return this.setLocalDateTimeFormat(DateTimeFormatter.ofPattern(localDateTimePattern));
    }

    public DateTimeFormatter getOffsetTimeFormat() {
        return this.offsetTimeFormat;
    }

    public JavaTimeModuleConfiguration setOffsetTimeFormat(DateTimeFormatter offsetTimeFormat) {
        this.offsetTimeFormat = this.applyRestrictions(offsetTimeFormat);
        return this;
    }

    public JavaTimeModuleConfiguration setOffsetTimeFormat(String offsetTimePattern) {
        return this.setOffsetTimeFormat(DateTimeFormatter.ofPattern(offsetTimePattern));
    }

    public DateTimeFormatter getOffsetDateTimeFormat() {
        return this.offsetDateTimeFormat;
    }

    public JavaTimeModuleConfiguration setOffsetDateTimeFormat(DateTimeFormatter offsetDateTimeFormat) {
        this.offsetDateTimeFormat = this.applyRestrictions(offsetDateTimeFormat);
        return this;
    }

    public JavaTimeModuleConfiguration setOffsetDateTimeFormat(String offsetDateTimePattern) {
        return this.setOffsetDateTimeFormat(DateTimeFormatter.ofPattern(offsetDateTimePattern));
    }

    public DateTimeFormatter getZonedDateTimeFormat() {
        return this.zonedDateTimeFormat;
    }

    public JavaTimeModuleConfiguration setZonedDateTimeFormat(DateTimeFormatter zonedDateTimeFormat) {
        this.zonedDateTimeFormat = this.applyRestrictions(zonedDateTimeFormat);
        return this;
    }

    public JavaTimeModuleConfiguration setZonedDateTimeFormat(String zonedDateTimePattern) {
        return this.setZonedDateTimeFormat(DateTimeFormatter.ofPattern(zonedDateTimePattern));
    }

    public DateTimeFormatter getYearFormat() {
        return this.yearFormat;
    }

    public JavaTimeModuleConfiguration setYearFormat(DateTimeFormatter yearFormat) {
        this.yearFormat = this.applyRestrictions(yearFormat);
        return this;
    }

    public JavaTimeModuleConfiguration setYearFormat(String yearPattern) {
        return this.setYearFormat(DateTimeFormatter.ofPattern(yearPattern));
    }

    public DateTimeFormatter getYearMonthFormat() {
        return this.yearMonthFormat;
    }

    public JavaTimeModuleConfiguration setYearMonthFormat(DateTimeFormatter yearMonthFormat) {
        this.yearMonthFormat = this.applyRestrictions(yearMonthFormat);
        return this;
    }

    public JavaTimeModuleConfiguration setYearMonthFormat(String yearMonthPattern) {
        return this.setYearMonthFormat(DateTimeFormatter.ofPattern(yearMonthPattern));
    }

    public DateTimeFormatter getMonthDayFormat() {
        return this.monthDayFormat;
    }

    public JavaTimeModuleConfiguration setMonthDayFormat(DateTimeFormatter monthDayFormat) {
        this.monthDayFormat = this.applyRestrictions(monthDayFormat);
        return this;
    }

    public JavaTimeModuleConfiguration setMonthDayFormat(String monthDayPattern) {
        return this.setMonthDayFormat(DateTimeFormatter.ofPattern(monthDayPattern));
    }

    private DateTimeFormatter applyRestrictions(DateTimeFormatter formatter) {
        DateTimeFormatter processedFormatter = formatter;
        if (this.forceIsoChronology) {
            processedFormatter = processedFormatter.withChronology(IsoChronology.INSTANCE);
        }
        if (this.forceResolverStrict) {
            processedFormatter = processedFormatter.withResolverStyle(ResolverStyle.STRICT);
        }
        return processedFormatter;
    }
}

