/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions;

import io.goodforgod.testcontainers.extensions.ContainerMetadata;
import io.goodforgod.testcontainers.extensions.ContainerMode;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class AbstractContainerMetadata
implements ContainerMetadata {
    private final boolean network;
    private final String alias;
    private final String image;
    private final ContainerMode runMode;

    protected AbstractContainerMetadata(boolean network, String alias, String image, ContainerMode runMode) {
        this.network = network;
        this.runMode = runMode;
        this.alias = Optional.ofNullable(AbstractContainerMetadata.getEnvValue("Alias", alias)).filter(a -> !a.isBlank()).orElse(null);
        this.image = Optional.ofNullable(AbstractContainerMetadata.getEnvValue("Image", image)).filter(a -> !a.isBlank()).orElseThrow(() -> new IllegalArgumentException(String.valueOf(this.getClass()) + " expected image from '" + image + "' but received null"));
    }

    private static boolean isEnvironmentValue(String value) {
        return value != null && value.startsWith("${") && value.endsWith("}");
    }

    private static String getEnvValue(String name, String envOrValue) {
        if (AbstractContainerMetadata.isEnvironmentValue(envOrValue)) {
            String envProperty = envOrValue.substring(2, envOrValue.length() - 1);
            String[] environmentAndDefault = envProperty.split("\\|");
            if (environmentAndDefault.length > 2) {
                throw new IllegalArgumentException(name + " property can contain only 1 ':' symbol but got: " + envProperty);
            }
            if (environmentAndDefault.length == 2) {
                String envValue = System.getenv(environmentAndDefault[0]);
                if (envValue == null) {
                    return environmentAndDefault[1].isBlank() ? null : environmentAndDefault[1];
                }
                return envValue;
            }
            return System.getenv(environmentAndDefault[0]);
        }
        return envOrValue;
    }

    @Override
    public boolean networkShared() {
        return this.network;
    }

    @Override
    @Nullable
    public String networkAlias() {
        return this.alias;
    }

    @Override
    @NotNull
    public String image() {
        return this.image;
    }

    @Override
    @NotNull
    public ContainerMode runMode() {
        return this.runMode;
    }
}

