/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.jdbc;

import io.goodforgod.testcontainers.extensions.jdbc.JdbcConnectionClosableImpl;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcConnectionImpl;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcMigrationEngine;
import io.goodforgod.testcontainers.extensions.jdbc.Migration;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.JdbcDatabaseContainer;

public interface JdbcConnection
extends AutoCloseable {
    @NotNull
    public Params params();

    @NotNull
    public Optional<Params> paramsInNetwork();

    @NotNull
    public Connection openConnection();

    @NotNull
    public JdbcMigrationEngine migrationEngine(@NotNull Migration.Engines var1);

    public void execute(@NotNull @Language(value="SQL") String var1);

    public void executeFromResources(@NotNull String var1);

    public <T, E extends Throwable> Optional<T> queryOne(@NotNull @Language(value="SQL") String var1, @NotNull ResultSetMapper<T, E> var2) throws E;

    public <T, E extends Throwable> List<T> queryMany(@NotNull @Language(value="SQL") String var1, @NotNull ResultSetMapper<T, E> var2) throws E;

    public int count(@NotNull String var1);

    public void assertCountsNone(@NotNull String var1);

    public void assertCountsAtLeast(int var1, @NotNull String var2);

    public void assertCountsEquals(int var1, @NotNull String var2);

    public void assertQueriesNone(@NotNull @Language(value="SQL") String var1);

    public void assertQueriesAtLeast(int var1, @NotNull @Language(value="SQL") String var2);

    public void assertQueriesEquals(int var1, @NotNull @Language(value="SQL") String var2);

    public void assertInserted(@NotNull @Language(value="SQL") String var1);

    public void assertUpdated(@NotNull @Language(value="SQL") String var1);

    public void assertDeleted(@NotNull @Language(value="SQL") String var1);

    public boolean checkQueriesNone(@NotNull @Language(value="SQL") String var1);

    public boolean checkQueriesAtLeast(int var1, @NotNull @Language(value="SQL") String var2);

    public boolean checkQueriesEquals(int var1, @NotNull @Language(value="SQL") String var2);

    public boolean checkInserted(@NotNull @Language(value="SQL") String var1);

    public boolean checkUpdated(@Language(value="SQL") String var1);

    public boolean checkDeleted(@Language(value="SQL") String var1);

    @Override
    public void close();

    public static JdbcConnection forParams(String driverProtocol, String host, int port, String database, String username, String password) {
        String jdbcUrl = String.format("jdbc:%s://%s:%d/%s", driverProtocol, host, port, database);
        JdbcConnectionImpl.ParamsImpl params = new JdbcConnectionImpl.ParamsImpl(jdbcUrl, host, port, database, username, password);
        return new JdbcConnectionClosableImpl(params, null);
    }

    public static JdbcConnection forContainer(JdbcDatabaseContainer<?> container) {
        if (!container.isRunning()) {
            throw new IllegalStateException(container.getClass().getSimpleName() + " container is not running");
        }
        String jdbcUrl = container.getJdbcUrl();
        int from = jdbcUrl.indexOf("//");
        int to = jdbcUrl.indexOf("/", from + 2);
        int port = Integer.parseInt(jdbcUrl.substring(from, to).split(":")[1]);
        JdbcConnectionImpl.ParamsImpl params = new JdbcConnectionImpl.ParamsImpl(jdbcUrl, container.getHost(), port, container.getDatabaseName(), container.getUsername(), container.getPassword());
        String networkHost = (String)container.getNetworkAliases().get(0);
        Integer networkPort = container.getFirstMappedPort();
        String networkJdbcUrl = String.format("%s//%s:%d/%s", jdbcUrl.substring(0, from), networkHost, networkPort, container.getDatabaseName());
        JdbcConnectionImpl.ParamsImpl network = new JdbcConnectionImpl.ParamsImpl(networkJdbcUrl, container.getHost(), port, container.getDatabaseName(), container.getUsername(), container.getPassword());
        return new JdbcConnectionClosableImpl(params, network);
    }

    public static interface Params {
        @NotNull
        public String jdbcUrl();

        @NotNull
        public String host();

        public int port();

        @NotNull
        public String database();

        public String username();

        public String password();
    }

    @FunctionalInterface
    public static interface ResultSetMapper<R, E extends Throwable> {
        public R apply(@NotNull ResultSet var1) throws SQLException, E;
    }
}

