/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.jdbc;

import io.goodforgod.testcontainers.extensions.AbstractTestcontainersExtension;
import io.goodforgod.testcontainers.extensions.ContainerContext;
import io.goodforgod.testcontainers.extensions.ContainerMode;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcConnection;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcMetadata;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcMigrationEngine;
import io.goodforgod.testcontainers.extensions.jdbc.Migration;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.testcontainers.containers.JdbcDatabaseContainer;

@ApiStatus.Internal
abstract class AbstractTestcontainersJdbcExtension<Container extends JdbcDatabaseContainer<?>, Metadata extends JdbcMetadata>
extends AbstractTestcontainersExtension<JdbcConnection, Container, Metadata> {
    AbstractTestcontainersJdbcExtension() {
    }

    protected Class<JdbcConnection> getConnectionType() {
        return JdbcConnection.class;
    }

    private void tryMigrateIfRequired(JdbcMetadata metadata, ExtensionContext context) {
        JdbcMigrationEngine migrationEngine = ((JdbcConnection)this.getContainerContext(context).connection()).migrationEngine(metadata.migration().engine());
        migrationEngine.apply(Arrays.asList(metadata.migration().locations()));
    }

    private void tryDropIfRequired(JdbcMetadata metadata, ExtensionContext context) {
        JdbcMigrationEngine migrationEngine = ((JdbcConnection)this.getContainerContext(context).connection()).migrationEngine(metadata.migration().engine());
        migrationEngine.drop(Arrays.asList(metadata.migration().locations()));
    }

    protected abstract ContainerContext<JdbcConnection> createContainerContext(Container var1);

    protected ContainerContext<JdbcConnection> getContainerContext(ExtensionContext context) {
        JdbcMetadata metadata = (JdbcMetadata)this.getMetadata(context);
        return (ContainerContext)this.getStorage(context).get((Object)metadata.runMode(), ContainerContext.class);
    }

    public void beforeAll(ExtensionContext context) {
        super.beforeAll(context);
        JdbcMetadata metadata = (JdbcMetadata)this.getMetadata(context);
        if (metadata.migration().apply() == Migration.Mode.PER_CLASS) {
            this.tryMigrateIfRequired(metadata, context);
        }
    }

    public void beforeEach(ExtensionContext context) {
        JdbcMetadata metadata = (JdbcMetadata)this.getMetadata(context);
        if (metadata.runMode() == ContainerMode.PER_METHOD && metadata.migration().apply() == Migration.Mode.PER_CLASS) {
            throw new ExtensionConfigurationException(String.format("@%s can't apply migration in Migration.Mode.PER_CLASS mode when ContainerMode.PER_METHOD is used", this.getContainerAnnotation().getSimpleName()));
        }
        super.beforeEach(context);
        if (metadata.migration().apply() == Migration.Mode.PER_METHOD) {
            this.tryMigrateIfRequired(metadata, context);
        }
    }

    public void afterEach(ExtensionContext context) {
        JdbcMetadata metadata = (JdbcMetadata)this.getMetadata(context);
        if (metadata.migration().drop() == Migration.Mode.PER_METHOD && metadata.runMode() != ContainerMode.PER_METHOD) {
            this.tryDropIfRequired(metadata, context);
        }
        super.afterEach(context);
    }

    public void afterAll(ExtensionContext context) {
        JdbcMetadata metadata = (JdbcMetadata)this.getMetadata(context);
        if (metadata.migration().drop() == Migration.Mode.PER_CLASS && metadata.runMode() == ContainerMode.PER_RUN) {
            this.tryDropIfRequired(metadata, context);
        }
        super.afterAll(context);
    }
}

