/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.jdbc;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.goodforgod.testcontainers.extensions.jdbc.FlywayJdbcMigrationEngine;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcConnection;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcConnectionException;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcMigrationEngine;
import io.goodforgod.testcontainers.extensions.jdbc.LiquibaseJdbcMigrationEngine;
import io.goodforgod.testcontainers.extensions.jdbc.Migration;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApiStatus.Internal
class JdbcConnectionImpl
implements JdbcConnection {
    private static final Logger logger = LoggerFactory.getLogger(JdbcConnection.class);
    private final JdbcConnection.Params params;
    private final JdbcConnection.Params network;
    private volatile FlywayJdbcMigrationEngine flywayJdbcMigrationEngine;
    private volatile LiquibaseJdbcMigrationEngine liquibaseJdbcMigrationEngine;
    private volatile boolean isClosed = false;
    private volatile HikariDataSource dataSource;

    JdbcConnectionImpl(JdbcConnection.Params params, JdbcConnection.Params network) {
        this.params = params;
        this.network = network;
    }

    static JdbcConnection forProtocol(String driverProtocol, String host, int port, String database, String username, String password) {
        String jdbcUrl = String.format("jdbc:%s://%s:%d/%s", driverProtocol, host, port, database);
        ParamsImpl params = new ParamsImpl(jdbcUrl, host, port, database, username, password);
        return new JdbcConnectionImpl(params, null);
    }

    static JdbcConnection forJDBC(String jdbcUrl, String host, int port, String hostInNetwork, Integer portInNetwork, String database, String username, String password) {
        ParamsImpl network;
        ParamsImpl params = new ParamsImpl(jdbcUrl, host, port, database, username, password);
        if (hostInNetwork == null) {
            network = null;
        } else {
            String jdbcUrlInNetwork = jdbcUrl.replace(host + ":" + port, hostInNetwork + ":" + portInNetwork);
            network = new ParamsImpl(jdbcUrlInNetwork, hostInNetwork, portInNetwork, database, username, password);
        }
        return new JdbcConnectionImpl(params, network);
    }

    static JdbcConnection forExternal(String jdbcUrl, String username, String password) {
        URI uri = URI.create(jdbcUrl);
        String host = uri.getHost();
        int port = uri.getPort();
        int dbSeparator = uri.getPath().indexOf(59);
        String database = dbSeparator == -1 ? uri.getPath() : uri.getPath().substring(0, dbSeparator);
        ParamsImpl params = new ParamsImpl(jdbcUrl, host, port, database, username, password);
        return new JdbcConnectionImpl(params, null);
    }

    @Override
    @NotNull
    public JdbcMigrationEngine migrationEngine( @NotNull Migration.Engines engine) {
        if (engine == Migration.Engines.FLYWAY) {
            if (this.flywayJdbcMigrationEngine == null) {
                this.flywayJdbcMigrationEngine = new FlywayJdbcMigrationEngine(this);
            }
            return this.flywayJdbcMigrationEngine;
        }
        if (engine == Migration.Engines.LIQUIBASE) {
            if (this.liquibaseJdbcMigrationEngine == null) {
                this.liquibaseJdbcMigrationEngine = new LiquibaseJdbcMigrationEngine(this);
            }
            return this.liquibaseJdbcMigrationEngine;
        }
        throw new UnsupportedOperationException("Unsupported engine: " + String.valueOf((Object)engine));
    }

    @Override
    @NotNull
    public JdbcConnection.Params params() {
        return this.params;
    }

    @Override
    @NotNull
    public Optional<JdbcConnection.Params> paramsInNetwork() {
        return Optional.ofNullable(this.network);
    }

    @Override
    @NotNull
    public Connection openConnection() {
        if (this.isClosed) {
            throw new IllegalStateException("JdbcConnection was closed");
        }
        try {
            return this.dataSource().getConnection();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void execute(@Language(value="SQL") @NotNull String sql) {
        logger.debug("Executing SQL:\n{}", (Object)sql);
        try (Connection openedConnection = this.openConnection();
             Statement stmt = openedConnection.createStatement();){
            stmt.execute(sql);
        }
        catch (SQLException e) {
            throw new JdbcConnectionException(e);
        }
    }

    @Override
    public void executeFromResources(@NotNull String pathToResource) {
        logger.debug("Loading file from resources with path: {}", (Object)pathToResource);
        String resourceAsString = this.loadStringFromResources(pathToResource).orElseThrow(() -> new IllegalArgumentException("Couldn't find resource with path: " + pathToResource));
        this.execute(resourceAsString);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<String> loadStringFromResources(String path) {
        try (InputStream resource = JdbcConnectionImpl.class.getClassLoader().getResourceAsStream(path);){
            if (resource == null) {
                Optional<String> optional2 = Optional.empty();
                return optional2;
            }
            Optional<String> optional = Optional.of(new String(resource.readAllBytes(), StandardCharsets.UTF_8));
            return optional;
        }
        catch (Exception e) {
            logger.warn("Failed loading '{}' due to: {}", (Object)path, (Object)e.getMessage());
            return Optional.empty();
        }
    }

    @Override
    public int count(@NotNull String tableName) {
        return this.queryOne("SELECT COUNT(*) FROM " + tableName, rs -> rs.getInt(1)).orElse(0);
    }

    @Override
    public void assertCountsNone(@NotNull String tableName) {
        this.assertCountsEquals(0, tableName);
    }

    @Override
    public void assertCountsAtLeast(int expectedAtLeast, @NotNull String tableName) {
        int count = this.count(tableName);
        if (count < expectedAtLeast) {
            Assertions.assertEquals((int)expectedAtLeast, (int)count, (String)String.format("Expected to count in '%s' table at least %s rows but received %s", tableName, expectedAtLeast, count));
        }
    }

    @Override
    public void assertCountsEquals(int expected, @NotNull String tableName) {
        int count = this.count(tableName);
        Assertions.assertEquals((int)expected, (int)count, (String)String.format("Expected to count in '%s' table %s rows but received %s", tableName, expected, count));
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T, E extends Throwable> Optional<T> queryOne(@Language(value="SQL") @NotNull String sql, @NotNull JdbcConnection.ResultSetMapper<T, E> extractor) throws E {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T, E extends Throwable> List<T> queryMany(@Language(value="SQL") @NotNull String sql, @NotNull JdbcConnection.ResultSetMapper<T, E> extractor) throws E {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void assertQuery(@Language(value="SQL") String sql, QueryAssert consumer) {
        logger.debug("Executing SQL:\n{}", (Object)sql);
        try (Connection openedConnection = this.openConnection();
             PreparedStatement stmt = openedConnection.prepareStatement(sql);
             ResultSet rs = stmt.executeQuery();){
            consumer.accept(rs);
        }
        catch (SQLException e) {
            throw new JdbcConnectionException(e);
        }
    }

    @Override
    public void assertQueriesNone(@NotNull String sql) {
        this.assertQueriesEquals(0, sql);
    }

    @Override
    public void assertQueriesAtLeast(int expectedAtLeast, @NotNull String sql) {
        this.assertQuery(sql, rs -> {
            int counter;
            for (counter = 0; rs.next() && counter < expectedAtLeast; ++counter) {
            }
            Assertions.assertEquals((int)expectedAtLeast, (int)counter, (String)String.format("Expected to query at least %s rows but received %s for SQL: %s", expectedAtLeast, counter, sql.replace("\n", " ")));
        });
    }

    @Override
    public void assertQueriesEquals(int expected, @NotNull String sql) {
        this.assertQuery(sql, rs -> {
            int counter = 0;
            while (rs.next()) {
                ++counter;
            }
            Assertions.assertEquals((int)expected, (int)counter, (String)String.format("Expected to query %s rows but received %s for SQL: %s", expected, counter, sql.replace("\n", " ")));
        });
    }

    @Override
    public void assertInserted(@NotNull String sql) {
        logger.debug("Executing SQL:\n{}", (Object)sql);
        try (Connection openedConnection = this.openConnection();
             PreparedStatement stmt = openedConnection.prepareStatement(sql);){
            int rs = stmt.executeUpdate();
            if (rs == 0) {
                Assertions.fail((String)String.format("Expected query to update but it didn't for SQL: %s", sql.replace("\n", " ")));
            }
        }
        catch (SQLException e) {
            throw new JdbcConnectionException(e);
        }
    }

    @Override
    public void assertUpdated(@NotNull String sql) {
        this.assertInserted(sql);
    }

    @Override
    public void assertDeleted(@NotNull String sql) {
        this.assertInserted(sql);
    }

    /*
     * Exception decompiling
     */
    private boolean checkQuery(@Language(value="SQL") String sql, QueryChecker checker) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean checkQueriesNone(@NotNull String sql) {
        return this.checkQueriesEquals(0, sql);
    }

    @Override
    public boolean checkQueriesAtLeast(int expectedAtLeast, @NotNull String sql) {
        return this.checkQuery(sql, rs -> {
            int counter;
            for (counter = 0; rs.next() && counter < expectedAtLeast; ++counter) {
            }
            return expectedAtLeast == counter;
        });
    }

    @Override
    public boolean checkQueriesEquals(int expected, @NotNull String sql) {
        return this.checkQuery(sql, rs -> {
            int counter = 0;
            while (rs.next()) {
                ++counter;
            }
            return expected == counter;
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkInserted(@NotNull String sql) {
        logger.debug("Executing SQL: {}", (Object)sql);
        try (Connection openedConnection = this.openConnection();){
            boolean bl;
            block14: {
                PreparedStatement stmt = openedConnection.prepareStatement(sql);
                try {
                    int rs = stmt.executeUpdate();
                    boolean bl2 = bl = rs != 0;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            throw new JdbcConnectionException(e);
        }
    }

    @Override
    public boolean checkUpdated(String sql) {
        return this.checkInserted(sql);
    }

    @Override
    public boolean checkDeleted(String sql) {
        return this.checkInserted(sql);
    }

    protected HikariDataSource createDataSource() {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(this.params().jdbcUrl());
        hikariConfig.setUsername(this.params().username());
        hikariConfig.setPassword(this.params().password());
        hikariConfig.setAutoCommit(true);
        hikariConfig.setMinimumIdle(1);
        hikariConfig.setMaximumPoolSize(25);
        hikariConfig.setPoolName("jdbc-connection");
        hikariConfig.setLeakDetectionThreshold(10000L);
        hikariConfig.setConnectionTimeout(10000L);
        hikariConfig.setInitializationFailTimeout(10000L);
        return new HikariDataSource(hikariConfig);
    }

    final HikariDataSource dataSource() {
        if (this.dataSource == null) {
            try {
                this.dataSource = this.createDataSource();
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                    this.dataSource = this.createDataSource();
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return this.dataSource;
    }

    void stop() {
        this.isClosed = true;
        if (this.dataSource != null) {
            try {
                this.dataSource.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.dataSource = null;
            }
        }
        if (this.flywayJdbcMigrationEngine != null) {
            this.flywayJdbcMigrationEngine.close();
            this.flywayJdbcMigrationEngine = null;
        }
        if (this.liquibaseJdbcMigrationEngine != null) {
            this.liquibaseJdbcMigrationEngine.close();
            this.liquibaseJdbcMigrationEngine = null;
        }
    }

    @Override
    public void close() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JdbcConnectionImpl that = (JdbcConnectionImpl)o;
        return Objects.equals(this.params, that.params) && Objects.equals(this.network, that.network);
    }

    public int hashCode() {
        return Objects.hash(this.params, this.network);
    }

    public String toString() {
        return this.params().jdbcUrl();
    }

    static final class ParamsImpl
    implements JdbcConnection.Params {
        private final String jdbcUrl;
        private final String host;
        private final int port;
        private final String database;
        private final String username;
        private final String password;

        ParamsImpl(String jdbcUrl, String host, int port, String database, String username, String password) {
            this.jdbcUrl = jdbcUrl;
            this.host = host;
            this.port = port;
            this.database = database;
            this.username = username;
            this.password = password;
        }

        @Override
        @NotNull
        public String jdbcUrl() {
            return this.jdbcUrl;
        }

        @Override
        @NotNull
        public String host() {
            return this.host;
        }

        @Override
        public int port() {
            return this.port;
        }

        @Override
        @NotNull
        public String database() {
            return this.database;
        }

        @Override
        public String username() {
            return this.username;
        }

        @Override
        public String password() {
            return this.password;
        }

        public String toString() {
            return this.jdbcUrl;
        }
    }

    @FunctionalInterface
    static interface QueryAssert {
        public void accept(@NotNull ResultSet var1) throws SQLException;
    }

    @FunctionalInterface
    static interface QueryChecker {
        public boolean apply(@NotNull ResultSet var1) throws SQLException;
    }
}

