/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.kafka;

import io.goodforgod.testcontainers.extensions.kafka.Event;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@ApiStatus.Internal
final class EventImpl
implements Event {
    private final Event.Key key;
    private final Event.Value value;
    private final List<Event.Header> headers;

    EventImpl(Event.Key key, Event.Value value, List<Event.Header> headers) {
        this.key = key;
        this.value = value;
        this.headers = headers == null ? Collections.emptyList() : headers;
    }

    @Override
    public Event.Key key() {
        return this.key;
    }

    @Override
    @NotNull
    public Event.Value value() {
        return this.value;
    }

    @Override
    @NotNull
    public List<Event.Header> headers() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventImpl event = (EventImpl)o;
        return Objects.equals(this.key, event.key) && Objects.equals(this.value, event.value) && Objects.equals(this.headers, event.headers);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.headers);
    }

    public String toString() {
        if (this.key == null && this.headers.isEmpty()) {
            return "[value=" + this.value + "]";
        }
        if (this.key == null) {
            return "[value=" + this.value + ", headers=" + this.headers + "]";
        }
        if (this.headers == null) {
            return "[key=" + this.key + ", value=" + this.value + "]";
        }
        return "[key=" + this.key + ", value=" + this.value + ", headers=" + this.headers + "]";
    }

    static final class EventBuilder
    implements Event.Builder {
        private byte[] key;
        private byte[] value;
        private final List<Event.Header> headers = new ArrayList<Event.Header>();

        EventBuilder() {
        }

        @Override
        @NotNull
        public Event.Builder withKey(@NotNull String key) {
            return this.withKey(key.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        @NotNull
        public Event.Builder withKey(byte[] key) {
            this.key = key;
            return this;
        }

        @Override
        @NotNull
        public Event.Builder withValue(byte[] value) {
            this.value = value;
            return this;
        }

        @Override
        @NotNull
        public Event.Builder withValue(@NotNull String value) {
            return this.withValue(value.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        @NotNull
        public Event.Builder withValue(@NotNull JSONObject value) {
            return this.withValue(value.toString().getBytes(StandardCharsets.UTF_8));
        }

        @Override
        @NotNull
        public Event.Builder withValue(@NotNull JSONArray value) {
            return this.withValue(value.toString().getBytes(StandardCharsets.UTF_8));
        }

        @Override
        @NotNull
        public Event.Builder withHeader(@NotNull String key, byte[] value) {
            this.headers.add(new HeaderImpl(key, new ValueImpl(value)));
            return this;
        }

        @Override
        @NotNull
        public Event.Builder withHeader(@NotNull String key, @NotNull String value) {
            return this.withHeader(key, value.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        @NotNull
        public Event build() {
            return new EventImpl(new KeyImpl(this.key), new ValueImpl(this.value), List.copyOf(this.headers));
        }
    }

    static final class HeaderImpl
    implements Event.Header {
        private final String key;
        private final Event.Value value;

        HeaderImpl(String key, Event.Value value) {
            this.key = key;
            this.value = value;
        }

        @Override
        @NotNull
        public String key() {
            return this.key;
        }

        @Override
        @NotNull
        public Event.Value value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HeaderImpl header = (HeaderImpl)o;
            return Objects.equals(this.key, header.key) && Objects.equals(this.value, header.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return "[key=" + this.key + ", value=" + this.value + "]";
        }
    }

    static final class ValueImpl
    implements Event.Value {
        private final byte[] value;

        ValueImpl(byte[] value) {
            this.value = value;
        }

        @Override
        public byte[] asBytes() {
            return this.value;
        }

        @Override
        @NotNull
        public String asString() {
            return this.value == null ? "" : new String(this.value, StandardCharsets.UTF_8);
        }

        @Override
        @NotNull
        public JSONObject asJson() {
            return new JSONObject(this.asString());
        }

        @Override
        @NotNull
        public JSONArray asJsonArray() {
            return new JSONArray(this.asString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValueImpl value1 = (ValueImpl)o;
            return Objects.equals(this.asString(), value1.asString());
        }

        public int hashCode() {
            return Arrays.hashCode(this.value);
        }

        public String toString() {
            return this.asString();
        }
    }

    static final class KeyImpl
    implements Event.Key {
        private final byte[] key;

        KeyImpl(byte[] key) {
            this.key = key;
        }

        @Override
        public byte[] asBytes() {
            return this.key;
        }

        @Override
        @NotNull
        public String asString() {
            return this.key == null ? "" : new String(this.key, StandardCharsets.UTF_8);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyImpl key1 = (KeyImpl)o;
            return Objects.equals(this.asString(), key1.asString());
        }

        public int hashCode() {
            return Arrays.hashCode(this.key);
        }

        public String toString() {
            return this.asString();
        }
    }
}

