/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.kafka;

import io.goodforgod.testcontainers.extensions.ContainerContext;
import io.goodforgod.testcontainers.extensions.kafka.KafkaConnection;
import io.goodforgod.testcontainers.extensions.kafka.KafkaConnectionImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.KafkaContainer;

@ApiStatus.Internal
final class KafkaContext
implements ContainerContext<KafkaConnection> {
    private static final String EXTERNAL_TEST_KAFKA_BOOTSTRAP = "EXTERNAL_TEST_KAFKA_BOOTSTRAP_SERVERS";
    private static final String EXTERNAL_TEST_KAFKA_PREFIX = "EXTERNAL_TEST_KAFKA_";
    private final KafkaConnectionPool pool = new KafkaConnectionPool();
    private final KafkaContainer container;
    private volatile KafkaConnectionImpl connection;

    KafkaContext(KafkaContainer container) {
        this.container = container;
    }

    @NotNull
    public KafkaConnection connection() {
        if (this.connection == null) {
            Optional<KafkaConnection> connectionExternal = KafkaContext.getConnectionExternal();
            if (connectionExternal.isEmpty() && !this.container.isRunning()) {
                throw new IllegalStateException("KafkaConnection can't be create for container that is not running");
            }
            KafkaConnection containerConnection = connectionExternal.orElseGet(() -> {
                String alias = (String)this.container.getNetworkAliases().get(this.container.getNetworkAliases().size() - 1);
                Properties properties = new Properties();
                properties.put("bootstrap.servers", this.container.getBootstrapServers());
                Properties networkProperties = new Properties();
                networkProperties.put("bootstrap.servers", String.format("%s:%s", alias, "9092"));
                return new KafkaConnectionImpl(properties, networkProperties);
            });
            this.connection = (KafkaConnectionImpl)containerConnection;
        }
        return this.connection;
    }

    public void start() {
        Optional<KafkaConnection> connectionExternal = KafkaContext.getConnectionExternal();
        if (connectionExternal.isEmpty()) {
            this.container.start();
        }
    }

    public void stop() {
        if (this.connection != null) {
            this.connection.stop();
            this.connection = null;
        }
        this.pool.close();
        this.container.stop();
    }

    @NotNull
    KafkaConnectionPool pool() {
        return this.pool;
    }

    @NotNull
    private static Optional<KafkaConnection> getConnectionExternal() {
        String bootstrap = System.getenv(EXTERNAL_TEST_KAFKA_BOOTSTRAP);
        if (bootstrap != null) {
            Properties properties = new Properties();
            System.getenv().forEach((k, v) -> {
                if (k.startsWith(EXTERNAL_TEST_KAFKA_PREFIX)) {
                    String name = k.replace(EXTERNAL_TEST_KAFKA_PREFIX, "").replace("_", ".").toLowerCase();
                    properties.put(name, v);
                }
            });
            return Optional.of(new KafkaConnectionImpl(properties, null));
        }
        return Optional.empty();
    }

    public String toString() {
        return this.container.getDockerImageName();
    }

    static final class KafkaConnectionPool {
        private final List<KafkaConnectionImpl> connections = new ArrayList<KafkaConnectionImpl>();

        KafkaConnectionPool() {
        }

        void add(KafkaConnectionImpl connection) {
            this.connections.add(connection);
        }

        void clear() {
            for (KafkaConnectionImpl connection : this.connections) {
                try {
                    connection.clear();
                }
                catch (Exception exception) {}
            }
        }

        void close() {
            for (KafkaConnectionImpl connection : this.connections) {
                try {
                    connection.stop();
                }
                catch (Exception exception) {}
            }
            this.connections.clear();
        }
    }
}

