/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.mockserver;

import io.goodforgod.testcontainers.extensions.mockserver.MockServerConnection;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.mockserver.client.MockServerClient;

@ApiStatus.Internal
class MockServerConnectionImpl
implements MockServerConnection {
    private final MockServerConnection.Params params;
    private final MockServerConnection.Params network;
    private final MockServerClient client;

    MockServerConnectionImpl(MockServerConnection.Params params, MockServerConnection.Params network) {
        this.params = params;
        this.network = network;
        this.client = new MockServerClient(params.host(), params.port());
    }

    static MockServerConnection forContainer(String host, int port, String hostInNetwork, Integer portInNetwork) {
        ParamsImpl params = new ParamsImpl(host, port);
        ParamsImpl network = hostInNetwork == null ? null : new ParamsImpl(hostInNetwork, portInNetwork);
        return new MockServerConnectionImpl(params, network);
    }

    static MockServerConnection forExternal(String host, int port) {
        ParamsImpl params = new ParamsImpl(host, port);
        return new MockServerConnectionImpl(params, null);
    }

    @Override
    @NotNull
    public MockServerConnection.Params params() {
        return this.params;
    }

    @Override
    @NotNull
    public Optional<MockServerConnection.Params> paramsInNetwork() {
        return Optional.ofNullable(this.network);
    }

    @Override
    @NotNull
    public MockServerClient client() {
        return this.client;
    }

    void stop() {
        this.client.close();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockServerConnectionImpl that = (MockServerConnectionImpl)o;
        return Objects.equals(this.params, that.params) && Objects.equals(this.network, that.network);
    }

    public int hashCode() {
        return Objects.hash(this.params, this.network);
    }

    public String toString() {
        return this.params().toString();
    }

    private static final class ParamsImpl
    implements MockServerConnection.Params {
        private final String host;
        private final int port;

        ParamsImpl(String host, int port) {
            this.host = host;
            this.port = port;
        }

        @Override
        @NotNull
        public URI uri() {
            return URI.create(String.format("http://%s:%d", this.host, this.port));
        }

        @Override
        @NotNull
        public String host() {
            return this.host;
        }

        @Override
        public int port() {
            return this.port;
        }

        public String toString() {
            return this.uri().toString();
        }
    }
}

