/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.mockserver;

import io.goodforgod.testcontainers.extensions.ContainerContext;
import io.goodforgod.testcontainers.extensions.mockserver.MockServerConnection;
import io.goodforgod.testcontainers.extensions.mockserver.MockServerConnectionImpl;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.MockServerContainer;

@ApiStatus.Internal
final class MockServerContext
implements ContainerContext<MockServerConnection> {
    private static final String EXTERNAL_TEST_MOCKSERVER_HOST = "EXTERNAL_TEST_MOCKSERVER_HOST";
    private static final String EXTERNAL_TEST_MOCKSERVER_PORT = "EXTERNAL_TEST_MOCKSERVER_PORT";
    private volatile MockServerConnectionImpl connection;
    private final MockServerContainer container;

    MockServerContext(MockServerContainer container) {
        this.container = container;
    }

    @NotNull
    public MockServerConnection connection() {
        if (this.connection == null) {
            Optional<MockServerConnection> connectionExternal = MockServerContext.getConnectionExternal();
            if (connectionExternal.isEmpty() && !this.container.isRunning()) {
                throw new IllegalStateException("MockServerConnection can't be create for container that is not running");
            }
            MockServerConnection jdbcConnection = connectionExternal.orElseGet(() -> {
                String alias = (String)this.container.getNetworkAliases().get(this.container.getNetworkAliases().size() - 1);
                return MockServerConnectionImpl.forContainer(this.container.getHost(), this.container.getMappedPort(1080), alias, 1080);
            });
            this.connection = (MockServerConnectionImpl)jdbcConnection;
        }
        return this.connection;
    }

    public void start() {
        Optional<MockServerConnection> connectionExternal = MockServerContext.getConnectionExternal();
        if (connectionExternal.isEmpty()) {
            this.container.start();
        }
    }

    public void stop() {
        if (this.connection != null) {
            this.connection.stop();
            this.connection = null;
        }
        this.container.stop();
    }

    @NotNull
    private static Optional<MockServerConnection> getConnectionExternal() {
        String host = System.getenv(EXTERNAL_TEST_MOCKSERVER_HOST);
        String port = System.getenv(EXTERNAL_TEST_MOCKSERVER_PORT);
        if (host != null && port != null) {
            return Optional.of(MockServerConnectionImpl.forExternal(host, Integer.parseInt(port)));
        }
        return Optional.empty();
    }

    public String toString() {
        return this.container.getDockerImageName();
    }
}

