/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.mockserver;

import io.goodforgod.testcontainers.extensions.AbstractTestcontainersExtension;
import io.goodforgod.testcontainers.extensions.ContainerContext;
import io.goodforgod.testcontainers.extensions.mockserver.ConnectionMockServer;
import io.goodforgod.testcontainers.extensions.mockserver.ContainerMockServer;
import io.goodforgod.testcontainers.extensions.mockserver.MockServerConnection;
import io.goodforgod.testcontainers.extensions.mockserver.MockServerContext;
import io.goodforgod.testcontainers.extensions.mockserver.MockServerMetadata;
import io.goodforgod.testcontainers.extensions.mockserver.TestcontainersMockServer;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.MockServerContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.utility.DockerImageName;

@ApiStatus.Internal
class TestcontainersMockServerExtension
extends AbstractTestcontainersExtension<MockServerConnection, MockServerContainer, MockServerMetadata> {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{TestcontainersMockServerExtension.class});

    TestcontainersMockServerExtension() {
    }

    protected Class<MockServerContainer> getContainerType() {
        return MockServerContainer.class;
    }

    protected Class<? extends Annotation> getContainerAnnotation() {
        return ContainerMockServer.class;
    }

    protected Class<? extends Annotation> getConnectionAnnotation() {
        return ConnectionMockServer.class;
    }

    protected Class<MockServerConnection> getConnectionType() {
        return MockServerConnection.class;
    }

    protected ExtensionContext.Namespace getNamespace() {
        return NAMESPACE;
    }

    protected MockServerContainer createContainerDefault(MockServerMetadata metadata) {
        DockerImageName image = DockerImageName.parse((String)metadata.image()).asCompatibleSubstituteFor(DockerImageName.parse((String)"mockserver/mockserver"));
        MockServerContainer container = new MockServerContainer(image);
        String alias = Optional.ofNullable(metadata.networkAlias()).orElseGet(() -> "mockserver-" + System.currentTimeMillis());
        container.withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger(MockServerContainer.class)).withMdc("image", image.asCanonicalNameString()).withMdc("alias", alias));
        container.withStartupTimeout(Duration.ofMinutes(5L));
        container.setNetworkAliases(new ArrayList<String>(List.of(alias)));
        if (metadata.networkShared()) {
            container.withNetwork(Network.SHARED);
        }
        return container;
    }

    protected ContainerContext<MockServerConnection> createContainerContext(MockServerContainer container) {
        return new MockServerContext(container);
    }

    @NotNull
    protected Optional<MockServerMetadata> findMetadata(@NotNull ExtensionContext context) {
        return this.findAnnotation(TestcontainersMockServer.class, context).map(a -> new MockServerMetadata(a.network().shared(), a.network().alias(), a.image(), a.mode()));
    }

    public void beforeEach(ExtensionContext context) {
        super.beforeEach(context);
        MockServerConnection connection = (MockServerConnection)this.getContainerContext(context).connection();
        connection.client().reset();
    }
}

