/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.jdbc;

import io.goodforgod.testcontainers.extensions.ContainerContext;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcConnection;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcConnectionImpl;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.PostgreSQLContainer;

@ApiStatus.Internal
final class PostgreSQLContext
implements ContainerContext<JdbcConnection> {
    private static final String PROTOCOL = "postgresql";
    private static final String EXTERNAL_TEST_POSTGRES_JDBC_URL = "EXTERNAL_TEST_POSTGRES_JDBC_URL";
    private static final String EXTERNAL_TEST_POSTGRES_USERNAME = "EXTERNAL_TEST_POSTGRES_USERNAME";
    private static final String EXTERNAL_TEST_POSTGRES_PASSWORD = "EXTERNAL_TEST_POSTGRES_PASSWORD";
    private static final String EXTERNAL_TEST_POSTGRES_HOST = "EXTERNAL_TEST_POSTGRES_HOST";
    private static final String EXTERNAL_TEST_POSTGRES_PORT = "EXTERNAL_TEST_POSTGRES_PORT";
    private static final String EXTERNAL_TEST_POSTGRES_DATABASE = "EXTERNAL_TEST_POSTGRES_DATABASE";
    private volatile JdbcConnectionImpl connection;
    private final PostgreSQLContainer<?> container;

    PostgreSQLContext(PostgreSQLContainer<?> container) {
        this.container = container;
    }

    @NotNull
    public JdbcConnection connection() {
        if (this.connection == null) {
            Optional<JdbcConnection> connectionExternal = PostgreSQLContext.getConnectionExternal();
            if (connectionExternal.isEmpty() && !this.container.isRunning()) {
                throw new IllegalStateException("MysqlConnection can't be create for container that is not running");
            }
            JdbcConnection containerConnection = connectionExternal.orElseGet(() -> {
                String alias = (String)this.container.getNetworkAliases().get(this.container.getNetworkAliases().size() - 1);
                return JdbcConnectionImpl.forJDBC((String)this.container.getJdbcUrl(), (String)this.container.getHost(), (int)this.container.getMappedPort(PostgreSQLContainer.POSTGRESQL_PORT.intValue()), (String)alias, (Integer)PostgreSQLContainer.POSTGRESQL_PORT, (String)this.container.getDatabaseName(), (String)this.container.getUsername(), (String)this.container.getPassword());
            });
            this.connection = (JdbcConnectionImpl)containerConnection;
        }
        return this.connection;
    }

    public void start() {
        Optional<JdbcConnection> connectionExternal = PostgreSQLContext.getConnectionExternal();
        if (connectionExternal.isEmpty()) {
            this.container.start();
        }
    }

    public void stop() {
        if (this.connection != null) {
            this.connection.stop();
            this.connection = null;
        }
        this.container.stop();
    }

    @NotNull
    private static Optional<JdbcConnection> getConnectionExternal() {
        String url = System.getenv(EXTERNAL_TEST_POSTGRES_JDBC_URL);
        String host = System.getenv(EXTERNAL_TEST_POSTGRES_HOST);
        String port = System.getenv(EXTERNAL_TEST_POSTGRES_PORT);
        String user = System.getenv(EXTERNAL_TEST_POSTGRES_USERNAME);
        String password = System.getenv(EXTERNAL_TEST_POSTGRES_PASSWORD);
        String db = Optional.ofNullable(System.getenv(EXTERNAL_TEST_POSTGRES_DATABASE)).orElse("postgres");
        if (url != null) {
            if (host != null && port != null) {
                return Optional.of(JdbcConnectionImpl.forJDBC((String)url, (String)host, (int)Integer.parseInt(port), null, null, (String)db, (String)user, (String)password));
            }
            return Optional.of(JdbcConnectionImpl.forExternal((String)url, (String)user, (String)password));
        }
        if (host != null && port != null) {
            return Optional.of(JdbcConnectionImpl.forProtocol((String)PROTOCOL, (String)host, (int)Integer.parseInt(port), (String)db, (String)user, (String)password));
        }
        return Optional.empty();
    }

    public String toString() {
        return this.container.getDockerImageName();
    }
}

