/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.jdbc;

import io.goodforgod.testcontainers.extensions.ContainerContext;
import io.goodforgod.testcontainers.extensions.jdbc.AbstractTestcontainersJdbcExtension;
import io.goodforgod.testcontainers.extensions.jdbc.ConnectionPostgreSQL;
import io.goodforgod.testcontainers.extensions.jdbc.ContainerPostgreSQL;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcConnection;
import io.goodforgod.testcontainers.extensions.jdbc.JdbcMetadata;
import io.goodforgod.testcontainers.extensions.jdbc.PostgreSQLContext;
import io.goodforgod.testcontainers.extensions.jdbc.TestcontainersPostgreSQL;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.utility.DockerImageName;

final class TestcontainersPostgreSQLExtension
extends AbstractTestcontainersJdbcExtension<PostgreSQLContainer<?>, JdbcMetadata> {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{TestcontainersPostgreSQLExtension.class});

    TestcontainersPostgreSQLExtension() {
    }

    protected Class<PostgreSQLContainer<?>> getContainerType() {
        return PostgreSQLContainer.class;
    }

    protected Class<? extends Annotation> getContainerAnnotation() {
        return ContainerPostgreSQL.class;
    }

    protected Class<? extends Annotation> getConnectionAnnotation() {
        return ConnectionPostgreSQL.class;
    }

    protected ExtensionContext.Namespace getNamespace() {
        return NAMESPACE;
    }

    protected PostgreSQLContainer<?> createContainerDefault(JdbcMetadata metadata) {
        DockerImageName image = DockerImageName.parse((String)metadata.image()).asCompatibleSubstituteFor(DockerImageName.parse((String)"gvenzl/oracle-xe"));
        PostgreSQLContainer container = new PostgreSQLContainer(image);
        String alias = Optional.ofNullable(metadata.networkAlias()).orElseGet(() -> "oracle-" + System.currentTimeMillis());
        container.withDatabaseName("postgres");
        container.withUsername("postgres");
        container.withPassword("postgres");
        container.withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger(PostgreSQLContainer.class)).withMdc("image", image.asCanonicalNameString()).withMdc("alias", alias));
        container.withStartupTimeout(Duration.ofMinutes(2L));
        container.setNetworkAliases(new ArrayList<String>(List.of(alias)));
        if (metadata.networkShared()) {
            container.withNetwork(Network.SHARED);
        }
        return container;
    }

    protected ContainerContext<JdbcConnection> createContainerContext(PostgreSQLContainer<?> container) {
        return new PostgreSQLContext(container);
    }

    @NotNull
    protected Optional<JdbcMetadata> findMetadata(@NotNull ExtensionContext context) {
        return this.findAnnotation(TestcontainersPostgreSQL.class, context).map(a -> new JdbcMetadata(a.network().shared(), a.network().alias(), a.image(), a.mode(), a.migration()));
    }
}

