/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.redis;

import io.goodforgod.testcontainers.extensions.redis.JedisConnection;
import io.goodforgod.testcontainers.extensions.redis.RedisConnectionClosableImpl;
import io.goodforgod.testcontainers.extensions.redis.RedisConnectionImpl;
import io.goodforgod.testcontainers.extensions.redis.RedisContainer;
import io.goodforgod.testcontainers.extensions.redis.RedisKey;
import io.goodforgod.testcontainers.extensions.redis.RedisValue;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.util.JedisURIHelper;

public interface RedisConnection
extends AutoCloseable {
    @NotNull
    public Params params();

    @NotNull
    public Optional<Params> paramsInNetwork();

    @NotNull
    public JedisConnection getConnection();

    public void deleteAll();

    public int countPrefix(@NotNull RedisKey var1);

    public int count(RedisKey ... var1);

    public int count(@NotNull Collection<RedisKey> var1);

    public void assertCountsPrefixNone(@NotNull RedisKey var1);

    public void assertCountsNone(RedisKey ... var1);

    public void assertCountsNone(@NotNull Collection<RedisKey> var1);

    public List<RedisValue> assertCountsPrefixAtLeast(long var1, @NotNull RedisKey var3);

    public List<RedisValue> assertCountsPrefixEquals(long var1, @NotNull RedisKey var3);

    public List<RedisValue> assertCountsAtLeast(long var1, RedisKey ... var3);

    public List<RedisValue> assertCountsAtLeast(long var1, @NotNull Collection<RedisKey> var3);

    public List<RedisValue> assertCountsEquals(long var1, RedisKey ... var3);

    public List<RedisValue> assertCountsEquals(long var1, @NotNull Collection<RedisKey> var3);

    @Override
    public void close();

    public static RedisConnection forContainer(RedisContainer<?> container) {
        if (!container.isRunning()) {
            throw new IllegalStateException(((Object)container).getClass().getSimpleName() + " container is not running");
        }
        RedisConnectionImpl.ParamsImpl params = new RedisConnectionImpl.ParamsImpl(container.getHost(), container.getPort(), container.getUser(), container.getPassword(), container.getDatabase());
        String alias = (String)container.getNetworkAliases().get(container.getNetworkAliases().size() - 1);
        RedisConnectionImpl.ParamsImpl network = new RedisConnectionImpl.ParamsImpl(alias, RedisContainer.PORT, container.getUser(), container.getPassword(), container.getDatabase());
        return new RedisConnectionClosableImpl(params, network);
    }

    public static RedisConnection forURI(URI uri) {
        HostAndPort hostAndPort = JedisURIHelper.getHostAndPort((URI)uri);
        String user = JedisURIHelper.getUser((URI)uri);
        String password = JedisURIHelper.getPassword((URI)uri);
        int database = JedisURIHelper.getDBIndex((URI)uri);
        RedisConnectionImpl.ParamsImpl params = new RedisConnectionImpl.ParamsImpl(hostAndPort.getHost(), hostAndPort.getPort(), user, password, database);
        return new RedisConnectionClosableImpl(params, null);
    }

    public static RedisConnection forParams(String host, int port, int database, String username, String password) {
        RedisConnectionImpl.ParamsImpl params = new RedisConnectionImpl.ParamsImpl(host, port, username, password, database);
        return new RedisConnectionClosableImpl(params, null);
    }

    public static interface Params {
        @NotNull
        public URI uri();

        @NotNull
        public String host();

        public int port();

        public String username();

        public String password();

        public int database();
    }
}

