/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.redis;

import io.goodforgod.testcontainers.extensions.redis.JedisCommandsImpl;
import io.goodforgod.testcontainers.extensions.redis.JedisConnection;
import io.goodforgod.testcontainers.extensions.redis.RedisConnection;
import io.goodforgod.testcontainers.extensions.redis.RedisConnectionException;
import io.goodforgod.testcontainers.extensions.redis.RedisKey;
import io.goodforgod.testcontainers.extensions.redis.RedisValue;
import io.goodforgod.testcontainers.extensions.redis.RedisValueImpl;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.args.FlushMode;

@ApiStatus.Internal
class RedisConnectionImpl
implements RedisConnection {
    private static final Logger logger = LoggerFactory.getLogger(RedisConnection.class);
    private final RedisConnection.Params params;
    private final RedisConnection.Params network;
    private volatile boolean isClosed = false;
    private volatile JedisCommandsImpl jedis;

    RedisConnectionImpl(RedisConnection.Params params, RedisConnection.Params network) {
        this.params = params;
        this.network = network;
    }

    static RedisConnection forContainer(String host, int port, String hostInNetwork, Integer portInNetwork, int database, String username, String password) {
        ParamsImpl params = new ParamsImpl(host, port, username, password, database);
        ParamsImpl network = hostInNetwork == null ? null : new ParamsImpl(hostInNetwork, portInNetwork, username, password, database);
        return new RedisConnectionImpl(params, network);
    }

    static RedisConnection forExternal(String host, int port, int database, String username, String password) {
        ParamsImpl params = new ParamsImpl(host, port, username, password, database);
        return new RedisConnectionImpl(params, null);
    }

    @Override
    @NotNull
    public RedisConnection.Params params() {
        return this.params;
    }

    @Override
    @NotNull
    public Optional<RedisConnection.Params> paramsInNetwork() {
        return Optional.ofNullable(this.network);
    }

    @NotNull
    private JedisConnection connection() {
        if (this.isClosed) {
            throw new IllegalStateException("RedisConnection was closed");
        }
        if (this.jedis == null) {
            try {
                DefaultJedisClientConfig.Builder config = DefaultJedisClientConfig.builder().timeoutMillis((int)Duration.ofSeconds(10L).toMillis()).blockingSocketTimeoutMillis((int)Duration.ofSeconds(10L).toMillis()).clientName("testcontainers-extensions-redis").database(0);
                if (this.params().username() != null) {
                    config.user(this.params.username());
                }
                if (this.params().password() != null) {
                    config.password(this.params().password());
                }
                this.jedis = new JedisCommandsImpl(new HostAndPort(this.params().host(), this.params().port()), (JedisClientConfig)config.build());
            }
            catch (Exception e) {
                throw new RedisConnectionException(e);
            }
        }
        return this.jedis;
    }

    @Override
    @NotNull
    public JedisConnection getConnection() {
        return this.connection();
    }

    @Override
    public void deleteAll() {
        try {
            this.connection().flushAll(FlushMode.SYNC);
        }
        catch (RedisConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RedisConnectionException(e);
        }
    }

    private List<RedisValue> getValuesByKeys(@NotNull Collection<RedisKey> keys) {
        if (keys.isEmpty()) {
            return Collections.emptyList();
        }
        byte[][] keysAsBytes = (byte[][])keys.stream().map(RedisKey::asBytes).toArray(x$0 -> new byte[x$0][]);
        try {
            logger.debug("Looking for keys: {}", keys);
            return this.connection().mget(keysAsBytes).stream().filter(Objects::nonNull).map(RedisValueImpl::new).collect(Collectors.toList());
        }
        catch (RedisConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RedisConnectionException(e);
        }
    }

    private List<RedisValue> getValuesByPrefix(RedisKey keyPrefix) {
        try {
            byte[] prefix = (keyPrefix.asString() + "*").getBytes(StandardCharsets.UTF_8);
            List<RedisKey> keys = this.connection().keys(prefix).stream().filter(Objects::nonNull).map(RedisKey::of).collect(Collectors.toList());
            return this.getValuesByKeys(keys);
        }
        catch (RedisConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RedisConnectionException(e);
        }
    }

    @Override
    public int countPrefix(@NotNull RedisKey keyPrefix) {
        return this.getValuesByPrefix(keyPrefix).size();
    }

    @Override
    public int count(RedisKey ... keys) {
        return this.count(List.of(keys));
    }

    @Override
    public int count(@NotNull Collection<RedisKey> keys) {
        return Math.toIntExact(this.getValuesByKeys(keys).stream().filter(Objects::nonNull).count());
    }

    @Override
    public void assertCountsPrefixNone(@NotNull RedisKey keyPrefix) {
        this.assertCountsPrefixEquals(0L, keyPrefix);
    }

    @Override
    public void assertCountsNone(RedisKey ... keys) {
        this.assertCountsNone(Arrays.asList(keys));
    }

    @Override
    public void assertCountsNone(@NotNull Collection<RedisKey> keys) {
        List<RedisValue> values = this.getValuesByKeys(keys);
        long count = values.size();
        Assertions.assertEquals((long)0L, (long)count, (String)String.format("Expected to count 0 for keys %s but found %s", keys, count));
    }

    @Override
    public List<RedisValue> assertCountsPrefixAtLeast(long expectedAtLeast, @NotNull RedisKey keyPrefix) {
        List<RedisValue> keyToValue = this.getValuesByPrefix(keyPrefix);
        long count = keyToValue.size();
        if (count < expectedAtLeast) {
            Assertions.assertEquals((long)expectedAtLeast, (long)count, (String)String.format("Expected to count for prefix '%s' at least %s values but received %s", keyPrefix, expectedAtLeast, count));
        }
        return keyToValue;
    }

    @Override
    public List<RedisValue> assertCountsPrefixEquals(long expected, @NotNull RedisKey keyPrefix) {
        List<RedisValue> keyToValue = this.getValuesByPrefix(keyPrefix);
        long count = keyToValue.size();
        Assertions.assertEquals((long)expected, (long)count, (String)String.format("Expected to count for '%s' prefix %s values but received %s", keyPrefix, expected, count));
        return keyToValue;
    }

    @Override
    public List<RedisValue> assertCountsAtLeast(long expectedAtLeast, RedisKey ... keys) {
        return this.assertCountsAtLeast(expectedAtLeast, List.of(keys));
    }

    @Override
    public List<RedisValue> assertCountsAtLeast(long expectedAtLeast, @NotNull Collection<RedisKey> keys) {
        List<RedisValue> values = this.getValuesByKeys(keys);
        long count = values.size();
        if (count < expectedAtLeast) {
            Assertions.assertEquals((long)expectedAtLeast, (long)count, (String)String.format("Expected to count at least %s values but received %s for keys %s", expectedAtLeast, count, keys));
        }
        return values;
    }

    @Override
    public List<RedisValue> assertCountsEquals(long expected, RedisKey ... keys) {
        return this.assertCountsEquals(expected, List.of(keys));
    }

    @Override
    public List<RedisValue> assertCountsEquals(long expected, @NotNull Collection<RedisKey> keys) {
        List<RedisValue> values = this.getValuesByKeys(keys);
        long count = values.size();
        Assertions.assertEquals((long)expected, (long)count, (String)String.format("Expected to count %s values but received %s for keys %s", expected, count, keys));
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisConnectionImpl that = (RedisConnectionImpl)o;
        return Objects.equals(this.params, that.params) && Objects.equals(this.network, that.network);
    }

    public int hashCode() {
        return Objects.hash(this.params, this.network);
    }

    public String toString() {
        return this.params().toString();
    }

    @Override
    public void close() {
    }

    void stop() {
        if (this.jedis != null) {
            this.jedis.close();
            this.jedis = null;
            this.isClosed = true;
        }
    }

    static final class ParamsImpl
    implements RedisConnection.Params {
        private final String host;
        private final int port;
        private final String username;
        private final String password;
        private final int database;

        ParamsImpl(String host, int port, String username, String password, int database) {
            this.host = host;
            this.port = port;
            this.username = username;
            this.password = password;
            this.database = database;
        }

        @Override
        @NotNull
        public URI uri() {
            return this.username() == null && this.password() == null ? URI.create(String.format("redis://%s:%s/%s", this.host(), this.port(), this.database())) : URI.create(String.format("redis://%s:%s@%s:%s/%s", this.username(), this.password(), this.host(), this.port(), this.database()));
        }

        @Override
        @NotNull
        public String host() {
            return this.host;
        }

        @Override
        public int port() {
            return this.port;
        }

        @Override
        public String username() {
            return this.username;
        }

        @Override
        public String password() {
            return this.password;
        }

        @Override
        public int database() {
            return this.database;
        }

        public String toString() {
            return this.uri().toString();
        }
    }
}

