/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.redis;

import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.DockerImageName;

public class RedisContainer<SELF extends RedisContainer<SELF>>
extends GenericContainer<SELF> {
    public static final Integer PORT = 6379;
    private static final String IMAGE_NAME = "redis";
    private static final DockerImageName IMAGE = DockerImageName.parse((String)"redis");
    private static final String DEFAULT_USER = "default";
    private static final String DEFAULT_PASSWORD = "redis";
    private static final int DEFAULT_DATABASE = 0;
    private Duration waitAfterStart = Duration.ZERO;

    public RedisContainer(String dockerImageName) {
        this(DockerImageName.parse((String)dockerImageName));
    }

    public RedisContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
        dockerImageName.assertCompatibleWith(new DockerImageName[]{IMAGE});
        this.withExposedPorts(new Integer[]{PORT});
        this.withCommand(new String[]{"redis-server", "--requirepass redis"});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Ready to accept connections.*", (int)1));
        this.withStartupTimeout(Duration.ofSeconds(30L));
    }

    public void start() {
        super.start();
        if (this.waitAfterStart != Duration.ZERO) {
            try {
                Thread.sleep(this.waitAfterStart.toMillis());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getUser() {
        return DEFAULT_USER;
    }

    public String getPassword() {
        return "redis";
    }

    public int getDatabase() {
        return 0;
    }

    public int getPort() {
        return this.getMappedPort(PORT);
    }

    public SELF waitAfterStart(@NotNull Duration duration) {
        this.waitAfterStart = duration;
        return (SELF)((Object)((RedisContainer)this.self()));
    }
}

