/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.redis;

import io.goodforgod.testcontainers.extensions.ContainerContext;
import io.goodforgod.testcontainers.extensions.redis.RedisConnection;
import io.goodforgod.testcontainers.extensions.redis.RedisConnectionImpl;
import io.goodforgod.testcontainers.extensions.redis.RedisContainer;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class RedisContext
implements ContainerContext<RedisConnection> {
    private static final String EXTERNAL_TEST_REDIS_USERNAME = "EXTERNAL_TEST_REDIS_USERNAME";
    private static final String EXTERNAL_TEST_REDIS_PASSWORD = "EXTERNAL_TEST_REDIS_PASSWORD";
    private static final String EXTERNAL_TEST_REDIS_HOST = "EXTERNAL_TEST_REDIS_HOST";
    private static final String EXTERNAL_TEST_REDIS_PORT = "EXTERNAL_TEST_REDIS_PORT";
    private static final String EXTERNAL_TEST_REDIS_DATABASE = "EXTERNAL_TEST_REDIS_DATABASE";
    private volatile RedisConnectionImpl connection;
    private final RedisContainer<?> container;

    RedisContext(RedisContainer<?> container) {
        this.container = container;
    }

    @NotNull
    public RedisConnection connection() {
        if (this.connection == null) {
            Optional<RedisConnection> connectionExternal = RedisContext.getConnectionExternal();
            if (connectionExternal.isEmpty() && !this.container.isRunning()) {
                throw new IllegalStateException("RedisConnection can't be create for container that is not running");
            }
            RedisConnection containerConnection = connectionExternal.orElseGet(() -> {
                String alias = (String)this.container.getNetworkAliases().get(this.container.getNetworkAliases().size() - 1);
                return RedisConnectionImpl.forContainer(this.container.getHost(), this.container.getMappedPort(RedisContainer.PORT), alias, RedisContainer.PORT, this.container.getDatabase(), this.container.getUser(), this.container.getPassword());
            });
            this.connection = (RedisConnectionImpl)containerConnection;
        }
        return this.connection;
    }

    public void start() {
        Optional<RedisConnection> connectionExternal = RedisContext.getConnectionExternal();
        if (connectionExternal.isEmpty()) {
            this.container.start();
        }
    }

    public void stop() {
        if (this.connection != null) {
            this.connection.stop();
            this.connection = null;
        }
        this.container.stop();
    }

    @NotNull
    private static Optional<RedisConnection> getConnectionExternal() {
        String host = System.getenv(EXTERNAL_TEST_REDIS_HOST);
        String port = System.getenv(EXTERNAL_TEST_REDIS_PORT);
        String user = System.getenv(EXTERNAL_TEST_REDIS_USERNAME);
        String password = System.getenv(EXTERNAL_TEST_REDIS_PASSWORD);
        Integer database = Optional.ofNullable(System.getenv(EXTERNAL_TEST_REDIS_DATABASE)).map(Integer::parseInt).orElse(0);
        if (host != null && port != null) {
            return Optional.of(RedisConnectionImpl.forExternal(host, Integer.parseInt(port), database, user, password));
        }
        return Optional.empty();
    }

    public String toString() {
        return this.container.getDockerImageName();
    }
}

