/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.redis;

import io.goodforgod.testcontainers.extensions.redis.RedisKeyImpl;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public interface RedisKey {
    public byte[] asBytes();

    @NotNull
    public String asString();

    @NotNull
    public static RedisKey of(byte[] key) {
        return new RedisKeyImpl(key);
    }

    @NotNull
    public static List<RedisKey> of(byte[] ... keys) {
        return Arrays.stream(keys).map(RedisKey::of).collect(Collectors.toList());
    }

    @NotNull
    public static RedisKey of(@NotNull String key) {
        return RedisKey.of(key.getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    public static List<RedisKey> of(String ... keys) {
        return Arrays.stream(keys).map(RedisKey::of).collect(Collectors.toList());
    }
}

