/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.redis;

import io.goodforgod.testcontainers.extensions.redis.RedisKey;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class RedisKeyImpl
implements RedisKey {
    private final byte[] key;

    RedisKeyImpl(byte[] key) {
        this.key = key;
    }

    @Override
    public byte[] asBytes() {
        return this.key;
    }

    @Override
    @NotNull
    public String asString() {
        return new String(this.key, StandardCharsets.UTF_8);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisKeyImpl key1 = (RedisKeyImpl)o;
        return Objects.equals(this.asString(), key1.asString());
    }

    public int hashCode() {
        return Arrays.hashCode(this.key);
    }

    public String toString() {
        return this.asString();
    }
}

