/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.redis;

import io.goodforgod.testcontainers.extensions.redis.RedisValue;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@ApiStatus.Internal
final class RedisValueImpl
implements RedisValue {
    private final byte[] value;

    RedisValueImpl(byte[] value) {
        this.value = value;
    }

    @Override
    public byte[] asBytes() {
        return this.value;
    }

    @Override
    @NotNull
    public String asString() {
        return new String(this.value, StandardCharsets.UTF_8);
    }

    @Override
    @NotNull
    public JSONObject asJson() {
        return new JSONObject(this.asString());
    }

    @Override
    @NotNull
    public JSONArray asJsonArray() {
        return new JSONArray(this.asString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisValueImpl value1 = (RedisValueImpl)o;
        return Objects.equals(this.asString(), value1.asString());
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public String toString() {
        return this.asString();
    }
}

