/*
 * Decompiled with CFR 0.152.
 */
package io.goodforgod.testcontainers.extensions.redis;

import io.goodforgod.testcontainers.extensions.AbstractTestcontainersExtension;
import io.goodforgod.testcontainers.extensions.ContainerContext;
import io.goodforgod.testcontainers.extensions.redis.ConnectionRedis;
import io.goodforgod.testcontainers.extensions.redis.ContainerRedis;
import io.goodforgod.testcontainers.extensions.redis.RedisConnection;
import io.goodforgod.testcontainers.extensions.redis.RedisContainer;
import io.goodforgod.testcontainers.extensions.redis.RedisContext;
import io.goodforgod.testcontainers.extensions.redis.RedisMetadata;
import io.goodforgod.testcontainers.extensions.redis.TestcontainersRedis;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.utility.DockerImageName;

@ApiStatus.Internal
class TestcontainersRedisExtension
extends AbstractTestcontainersExtension<RedisConnection, RedisContainer<?>, RedisMetadata> {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{TestcontainersRedisExtension.class});

    TestcontainersRedisExtension() {
    }

    protected Class<RedisContainer<?>> getContainerType() {
        return RedisContainer.class;
    }

    protected Class<? extends Annotation> getContainerAnnotation() {
        return ContainerRedis.class;
    }

    protected Class<? extends Annotation> getConnectionAnnotation() {
        return ConnectionRedis.class;
    }

    protected Class<RedisConnection> getConnectionType() {
        return RedisConnection.class;
    }

    protected ExtensionContext.Namespace getNamespace() {
        return NAMESPACE;
    }

    protected RedisContainer<?> createContainerDefault(RedisMetadata metadata) {
        DockerImageName image = DockerImageName.parse((String)metadata.image()).asCompatibleSubstituteFor(DockerImageName.parse((String)"redis"));
        RedisContainer container = new RedisContainer(image);
        String alias = Optional.ofNullable(metadata.networkAlias()).orElseGet(() -> "redis-" + System.currentTimeMillis());
        ((RedisContainer)container.withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger(RedisContainer.class)).withMdc("image", image.asCanonicalNameString()).withMdc("alias", alias))).withStartupTimeout(Duration.ofMinutes(5L));
        container.setNetworkAliases(new ArrayList<String>(List.of(alias)));
        if (metadata.networkShared()) {
            container.withNetwork(Network.SHARED);
        }
        return container;
    }

    protected ContainerContext<RedisConnection> createContainerContext(RedisContainer<?> container) {
        return new RedisContext(container);
    }

    @NotNull
    protected Optional<RedisMetadata> findMetadata(@NotNull ExtensionContext context) {
        return this.findAnnotation(TestcontainersRedis.class, context).map(a -> new RedisMetadata(a.network().shared(), a.network().alias(), a.image(), a.mode()));
    }
}

