/*
 * Decompiled with CFR 0.152.
 */
package org.graphframes.lib;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.UUID;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.graphx.Graph;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.storage.StorageLevel;
import org.graphframes.GraphFrame;
import org.graphframes.GraphFrame$;
import org.graphframes.Logging;
import org.graphframes.lib.ConnectedComponents;
import org.graphframes.lib.ConnectedComponents$;
import org.graphframes.lib.GraphXConversions$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class ConnectedComponents$
implements Logging {
    public static ConnectedComponents$ MODULE$;
    private final String COMPONENT;
    private final String ORIG_ID;
    private final String MIN_NBR;
    private final String CNT;
    private final String CHECKPOINT_NAME_PREFIX;
    private transient Logger org$graphframes$Logging$$logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ConnectedComponents$();
    }

    @Override
    public void logDebug(Function0<String> s) {
        Logging.logDebug$(this, s);
    }

    @Override
    public void logWarn(Function0<String> s) {
        Logging.logWarn$(this, s);
    }

    @Override
    public void logInfo(Function0<String> s) {
        Logging.logInfo$(this, s);
    }

    @Override
    public void logTrace(Function0<String> s) {
        Logging.logTrace$(this, s);
    }

    private Logger org$graphframes$Logging$$logger$lzycompute() {
        ConnectedComponents$ connectedComponents$ = this;
        synchronized (connectedComponents$) {
            if (!this.bitmap$trans$0) {
                this.org$graphframes$Logging$$logger = Logging.org$graphframes$Logging$$logger$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.org$graphframes$Logging$$logger;
    }

    @Override
    public Logger org$graphframes$Logging$$logger() {
        if (!this.bitmap$trans$0) {
            return this.org$graphframes$Logging$$logger$lzycompute();
        }
        return this.org$graphframes$Logging$$logger;
    }

    private String COMPONENT() {
        return this.COMPONENT;
    }

    private String ORIG_ID() {
        return this.ORIG_ID;
    }

    private String MIN_NBR() {
        return this.MIN_NBR;
    }

    private String CNT() {
        return this.CNT;
    }

    private String CHECKPOINT_NAME_PREFIX() {
        return this.CHECKPOINT_NAME_PREFIX;
    }

    private Dataset<Row> symmetrize(Dataset<Row> ee) {
        String EDGE = "_edge";
        return ee.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.explode(functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.DST())})), functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.DST()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).as(GraphFrame$.MODULE$.DST())}))}))).as(EDGE)})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringBuilder(1).append(EDGE).append(".").append(GraphFrame$.MODULE$.SRC()).toString()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(new StringBuilder(1).append(EDGE).append(".").append(GraphFrame$.MODULE$.DST()).toString()).as(GraphFrame$.MODULE$.DST())}));
    }

    private GraphFrame prepare(GraphFrame graph) {
        Dataset vertices = graph.indexedVertices().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.LONG_ID()).as(GraphFrame$.MODULE$.ID()), functions$.MODULE$.col(GraphFrame$.MODULE$.ATTR())}));
        Dataset edges = graph.indexedEdges().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.LONG_SRC()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.LONG_DST()).as(GraphFrame$.MODULE$.DST())}));
        Dataset orderedEdges = edges.filter(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).$eq$bang$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST()))).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.minValue(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.DST())).as(GraphFrame$.MODULE$.SRC()), this.maxValue(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.DST())).as(GraphFrame$.MODULE$.DST())})).distinct();
        return GraphFrame$.MODULE$.apply((Dataset<Row>)vertices, (Dataset<Row>)orderedEdges);
    }

    private Dataset<Row> minNbrs(Dataset<Row> ee) {
        return this.symmetrize(ee).groupBy(GraphFrame$.MODULE$.SRC(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.min(functions$.MODULE$.col(GraphFrame$.MODULE$.DST())).as(this.MIN_NBR()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.count("*").as(this.CNT())})).withColumn(this.MIN_NBR(), this.minValue(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(this.MIN_NBR())));
    }

    private Column minValue(Column x, Column y) {
        return functions$.MODULE$.when(x.$less((Object)y), (Object)x).otherwise((Object)y);
    }

    private Column maxValue(Column x, Column y) {
        return functions$.MODULE$.when(x.$greater((Object)y), (Object)x).otherwise((Object)y);
    }

    private Dataset<Row> skewedJoin(Dataset<Row> edges, Dataset<Row> minNbrs, int broadcastThreshold, String logPrefix) {
        Set hubs = new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])minNbrs.filter(functions$.MODULE$.col(this.CNT()).$greater((Object)BoxesRunTime.boxToInteger((int)broadcastThreshold))).select(GraphFrame$.MODULE$.SRC(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(edges.sparkSession().implicits().newLongEncoder()).collect())).toSet();
        return GraphFrame$.MODULE$.skewedJoin(edges, minNbrs, GraphFrame$.MODULE$.SRC(), hubs, logPrefix, ((TypeTags)package$.MODULE$.universe()).TypeTag().Long());
    }

    public Dataset<Row> run(GraphFrame graph) {
        return new ConnectedComponents(graph).run();
    }

    private Dataset<Row> runGraphX(GraphFrame graph, int maxIter) {
        Graph components = org.apache.spark.graphx.lib.ConnectedComponents$.MODULE$.run(graph.cachedTopologyGraphX(), maxIter, ClassTag$.MODULE$.Unit(), ClassTag$.MODULE$.Unit());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_graphframes_lib_ConnectedComponents$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("org")), (Symbols.SymbolApi)$m.staticPackage("org.apache")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.graphx")), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.graphx.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("org.apache.spark.graphx.package").asModule().moduleClass(), "VertexId"), (List)Nil$.MODULE$);
            }

            public Org_graphframes_lib_ConnectedComponents$$typecreator1$1() {
            }
        }
        return GraphXConversions$.MODULE$.fromGraphX(graph, components, (Seq<String>)((Seq)new .colon.colon((Object)this.COMPONENT(), (List)Nil$.MODULE$)), GraphXConversions$.MODULE$.fromGraphX$default$4(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_graphframes_lib_ConnectedComponents$$typecreator1$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Unit()).vertices();
    }

    public Dataset<Row> org$graphframes$lib$ConnectedComponents$$run(GraphFrame graph, boolean runInGraphX, int broadcastThreshold, int checkpointInterval, StorageLevel intermediateStorageLevel, boolean useLabelsAsComponents, Option<Object> maxIter) {
        Dataset dataset;
        if (runInGraphX) {
            return this.runGraphX(graph, BoxesRunTime.unboxToInt((Object)maxIter.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE)));
        }
        SparkSession spark = graph.spark();
        SparkContext sc = spark.sparkContext();
        String originalAQE = spark.conf().get("spark.sql.adaptive.enabled");
        try {
            None$ none$;
            boolean shouldCheckpoint;
            spark.conf().set("spark.sql.adaptive.enabled", "false");
            String runId = (String)new StringOps(Predef$.MODULE$.augmentString(UUID.randomUUID().toString())).takeRight(8);
            String logPrefix = new StringBuilder(5).append("[CC ").append(runId).append("]").toString();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append(logPrefix).append(" Start connected components with run ID ").append(runId).append(".").toString());
            boolean bl = shouldCheckpoint = checkpointInterval > 0;
            if (shouldCheckpoint) {
                String dir = (String)sc.getCheckpointDir().map((Function1 & Serializable & scala.Serializable)d -> new Path(d, new StringBuilder(1).append(MODULE$.CHECKPOINT_NAME_PREFIX()).append("-").append(runId).toString()).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    Option option = spark.conf().getOption("spark.checkpoint.dir");
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String d = (String)some.value();
                        return new Path(d, new StringBuilder(1).append(MODULE$.CHECKPOINT_NAME_PREFIX()).append("-").append(runId).toString()).toString();
                    }
                    if (None$.MODULE$.equals(option)) {
                        throw new IOException("Checkpoint directory is not set. Please set it first using sc.setCheckpointDir()or by specifying the conf 'spark.checkpoint.dir'.");
                    }
                    throw new MatchError((Object)option);
                });
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append(logPrefix).append(" Using ").append(dir).append(" for checkpointing with interval ").append(checkpointInterval).append(".").toString());
                none$ = new Some((Object)dir);
            } else {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append(logPrefix).append(" Checkpointing is disabled because checkpointInterval=").append(checkpointInterval).append(".").toString());
                none$ = None$.MODULE$;
            }
            None$ checkpointDir = none$;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append(logPrefix).append(" Preparing the graph for connected component computation ...").toString());
            GraphFrame g = this.prepare(graph);
            Dataset<Row> vv = g.vertices();
            ObjectRef ee = ObjectRef.create((Object)g.edges().persist(intermediateStorageLevel));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append(logPrefix).append(" Found ").append(((Dataset)ee$1.elem).count()).append(" edges after preparation.").toString());
            boolean converged = false;
            IntRef iteration = IntRef.create((int)1);
            Dataset minNbrs1 = this.minNbrs((Dataset<Row>)((Dataset)ee.elem)).persist(intermediateStorageLevel);
            BigDecimal prevSum = this._calcMinNbrSum$1(minNbrs1, iteration);
            Seq lastRoundPersistedDFs = (Seq)new .colon.colon((Object)((Dataset)ee.elem), (List)new .colon.colon((Object)minNbrs1, (List)Nil$.MODULE$));
            while (!converged) {
                Seq currRoundPersistedDFs = (Seq)Nil$.MODULE$;
                ee.elem = this.skewedJoin((Dataset<Row>)((Dataset)ee.elem), (Dataset<Row>)minNbrs1, broadcastThreshold, logPrefix).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.DST()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(this.MIN_NBR()).as(GraphFrame$.MODULE$.DST())})).distinct().persist(intermediateStorageLevel);
                currRoundPersistedDFs = (Seq)currRoundPersistedDFs.$colon$plus((Object)((Dataset)ee.elem), Seq$.MODULE$.canBuildFrom());
                Dataset minNbrs2 = ((Dataset)ee.elem).groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(GraphFrame$.MODULE$.SRC())})).agg(functions$.MODULE$.min(functions$.MODULE$.col(GraphFrame$.MODULE$.DST())).as(this.MIN_NBR()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.count("*").as(this.CNT())})).persist(intermediateStorageLevel);
                currRoundPersistedDFs = (Seq)currRoundPersistedDFs.$colon$plus((Object)minNbrs2, Seq$.MODULE$.canBuildFrom());
                ee.elem = this.skewedJoin((Dataset<Row>)((Dataset)ee.elem), (Dataset<Row>)minNbrs2, broadcastThreshold, logPrefix).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.MIN_NBR()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.DST())})).filter(functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).$eq$bang$eq((Object)functions$.MODULE$.col(GraphFrame$.MODULE$.DST())));
                ee.elem = ((Dataset)ee.elem).union(minNbrs2.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.MIN_NBR()).as(GraphFrame$.MODULE$.SRC()), functions$.MODULE$.col(GraphFrame$.MODULE$.SRC()).as(GraphFrame$.MODULE$.DST())}))).distinct();
                if (shouldCheckpoint && iteration.elem % checkpointInterval == 0) {
                    Object object;
                    String out = new StringBuilder(1).append(checkpointDir.get()).append("/").append(iteration.elem).toString();
                    ((Dataset)ee.elem).write().parquet(out);
                    ee.elem = spark.read().parquet(out);
                    if (iteration.elem > checkpointInterval) {
                        Path path = new Path(new StringBuilder(1).append(checkpointDir.get()).append("/").append(iteration.elem - checkpointInterval).toString());
                        object = BoxesRunTime.boxToBoolean((boolean)path.getFileSystem(sc.hadoopConfiguration()).delete(path, true));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                    System.gc();
                }
                ((Dataset)ee.elem).persist(intermediateStorageLevel);
                currRoundPersistedDFs = (Seq)currRoundPersistedDFs.$colon$plus((Object)((Dataset)ee.elem), Seq$.MODULE$.canBuildFrom());
                minNbrs1 = this.minNbrs((Dataset<Row>)((Dataset)ee.elem)).persist(intermediateStorageLevel);
                currRoundPersistedDFs = (Seq)currRoundPersistedDFs.$colon$plus((Object)minNbrs1, Seq$.MODULE$.canBuildFrom());
                BigDecimal currSum = this._calcMinNbrSum$1(minNbrs1, iteration);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append(logPrefix).append(" Sum of assigned components in iteration ").append(iteration$1.elem).append(": ").append(currSum).append(".").toString());
                if (BoxesRunTime.equalsNumNum((Number)currSum, (Number)prevSum)) {
                    converged = true;
                } else {
                    prevSum = currSum;
                }
                lastRoundPersistedDFs.foreach((Function1 & Serializable & scala.Serializable)persisted_df -> persisted_df.unpersist());
                lastRoundPersistedDFs = currRoundPersistedDFs;
                ++iteration.elem;
            }
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append(logPrefix).append(" Connected components converged in ").append(iteration$1.elem - 1).append(" iterations.").toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append(logPrefix).append(" Join and return component assignments with original vertex IDs.").toString());
            Dataset indexedLabel = vv.join((Dataset)ee.elem, vv.apply(GraphFrame$.MODULE$.ID()).$eq$eq$eq((Object)((Dataset)ee.elem).apply(GraphFrame$.MODULE$.DST())), "left_outer").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{vv.apply(GraphFrame$.MODULE$.ATTR()), functions$.MODULE$.when(((Dataset)ee.elem).apply(GraphFrame$.MODULE$.SRC()).isNull(), (Object)vv.apply(GraphFrame$.MODULE$.ID())).otherwise((Object)((Dataset)ee.elem).apply(GraphFrame$.MODULE$.SRC())).as(this.COMPONENT()), functions$.MODULE$.col(new StringBuilder(1).append(GraphFrame$.MODULE$.ATTR()).append(".").append(GraphFrame$.MODULE$.ID()).toString()).as(GraphFrame$.MODULE$.ID())}));
            Dataset output = graph.hasIntegralIdType() || !useLabelsAsComponents ? indexedLabel.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringBuilder(2).append(GraphFrame$.MODULE$.ATTR()).append(".*").toString()), functions$.MODULE$.col(this.COMPONENT())})).persist(intermediateStorageLevel) : indexedLabel.join(indexedLabel.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.COMPONENT())})).agg(functions$.MODULE$.min(functions$.MODULE$.col(GraphFrame$.MODULE$.ID())).as(this.ORIG_ID()), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.COMPONENT()), functions$.MODULE$.col(this.ORIG_ID())})), this.COMPONENT()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(new StringBuilder(2).append(GraphFrame$.MODULE$.ATTR()).append(".*").toString()), functions$.MODULE$.col(this.ORIG_ID()).as(this.COMPONENT())})).persist(intermediateStorageLevel);
            output.count();
            lastRoundPersistedDFs.foreach((Function1 & Serializable & scala.Serializable)persisted_df -> persisted_df.unpersist());
            this.logWarn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The DataFrame returned by ConnectedComponents is persisted and loaded.");
            dataset = output;
        }
        finally {
            spark.conf().set("spark.sql.adaptive.enabled", originalAQE);
        }
        return dataset;
    }

    private final BigDecimal _calcMinNbrSum$1(Dataset minNbrsDF, IntRef iteration$1) {
        Tuple2 tuple2 = (Tuple2)minNbrsDF.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sum(functions$.MODULE$.col(this.MIN_NBR()).cast((DataType)new DecimalType(20, 0))), functions$.MODULE$.count("*")})).rdd().map((Function1 & Serializable & scala.Serializable)r -> new Tuple2(r.getAs(0), (Object)BoxesRunTime.boxToLong((long)r.getLong(1))), ClassTag$.MODULE$.apply(Tuple2.class)).first();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BigDecimal minNbrSum = (BigDecimal)tuple2._1();
        long cnt = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)minNbrSum, (Object)BoxesRunTime.boxToLong((long)cnt));
        BigDecimal minNbrSum2 = (BigDecimal)tuple22._1();
        long cnt2 = tuple22._2$mcJ$sp();
        if (cnt2 != 0L && minNbrSum2 == null) {
            throw new ArithmeticException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(388).append("\n               |The total sum of edge src IDs is used to determine convergence during iterations.\n               |However, the total sum at iteration ").append(iteration$1.elem).append(" exceeded 30 digits (1e30),\n               |which should happen only if the graph contains more than 200 billion edges.\n               |If not, please file a bug report at https://github.com/graphframes/graphframes/issues.\n              ").toString())).stripMargin());
        }
        return minNbrSum2;
    }

    private ConnectedComponents$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.COMPONENT = "component";
        this.ORIG_ID = "orig_id";
        this.MIN_NBR = "min_nbr";
        this.CNT = "cnt";
        this.CHECKPOINT_NAME_PREFIX = "connected-components";
    }
}

