/*
 * Decompiled with CFR 0.152.
 */
package org.graphframes;

import java.io.Serializable;
import java.util.Random;
import org.apache.spark.graphx.Graph;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel$;
import org.graphframes.GraphFrame;
import org.graphframes.GraphFrame$;
import org.graphframes.GraphFramesUnreachableException;
import org.graphframes.InvalidPatternException;
import org.graphframes.Logging;
import org.graphframes.lib.GraphXConversions$;
import org.graphframes.pattern.AnonymousEdge;
import org.graphframes.pattern.AnonymousVertex$;
import org.graphframes.pattern.Edge;
import org.graphframes.pattern.NamedEdge;
import org.graphframes.pattern.NamedVertex;
import org.graphframes.pattern.Negation;
import org.graphframes.pattern.Pattern;
import org.graphframes.pattern.Vertex;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public final class GraphFrame$
implements scala.Serializable,
Logging {
    public static GraphFrame$ MODULE$;
    private final String ID;
    private final String SRC;
    private final String DST;
    private final String EDGE;
    private final String WEIGHT;
    private final String ATTR;
    private final String LONG_ID;
    private final String LONG_SRC;
    private final String LONG_DST;
    private final String GX_ATTR;
    private final Random random;
    private int _broadcastThreshold;
    private transient Logger org$graphframes$Logging$$logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new GraphFrame$();
    }

    @Override
    public void logDebug(Function0<String> s) {
        Logging.logDebug$(this, s);
    }

    @Override
    public void logWarn(Function0<String> s) {
        Logging.logWarn$(this, s);
    }

    @Override
    public void logInfo(Function0<String> s) {
        Logging.logInfo$(this, s);
    }

    @Override
    public void logTrace(Function0<String> s) {
        Logging.logTrace$(this, s);
    }

    private Logger org$graphframes$Logging$$logger$lzycompute() {
        GraphFrame$ graphFrame$ = this;
        synchronized (graphFrame$) {
            if (!this.bitmap$trans$0) {
                this.org$graphframes$Logging$$logger = Logging.org$graphframes$Logging$$logger$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.org$graphframes$Logging$$logger;
    }

    @Override
    public Logger org$graphframes$Logging$$logger() {
        if (!this.bitmap$trans$0) {
            return this.org$graphframes$Logging$$logger$lzycompute();
        }
        return this.org$graphframes$Logging$$logger;
    }

    public <T> Dataset<Row> skewedJoin(Dataset<Row> a, Dataset<Row> b, String joinCol, Set<T> hubs, String logPrefix) {
        if (hubs.isEmpty()) {
            return a.join(b, joinCol);
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append(logPrefix).append(" Skewed join with ").append(hubs.size()).append(" high-degree keys.").toString());
        Function1 & Serializable & scala.Serializable isHub = (Function1 & Serializable & scala.Serializable)c -> c.isInCollection((Iterable)hubs);
        Dataset hashJoined = a.filter(((Column)isHub.apply((Object)functions$.MODULE$.col(joinCol))).unary_$bang()).join(b.filter(((Column)isHub.apply((Object)functions$.MODULE$.col(joinCol))).unary_$bang()), joinCol);
        Dataset broadcastJoined = a.filter((Column)isHub.apply((Object)functions$.MODULE$.col(joinCol))).join(functions$.MODULE$.broadcast(b.filter((Column)isHub.apply((Object)functions$.MODULE$.col(joinCol)))), joinCol);
        return hashJoined.unionAll(broadcastJoined);
    }

    public String ID() {
        return this.ID;
    }

    public String SRC() {
        return this.SRC;
    }

    public String DST() {
        return this.DST;
    }

    public String EDGE() {
        return this.EDGE;
    }

    public String WEIGHT() {
        return this.WEIGHT;
    }

    public GraphFrame apply(Dataset<Row> vertices, Dataset<Row> edges) {
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])vertices.columns())).contains((Object)this.ID()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Vertex ID column '").append(MODULE$.ID()).append("' missing from vertex DataFrame, which has columns: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])vertices.columns())).mkString(",")).toString());
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges.columns())).contains((Object)this.SRC()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(75).append("Source vertex ID column '").append(MODULE$.SRC()).append("' missing from edge DataFrame, which has columns: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges.columns())).mkString(",")).toString());
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges.columns())).contains((Object)this.DST()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(80).append("Destination vertex ID column '").append(MODULE$.DST()).append("' missing from edge DataFrame, which has columns: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])edges.columns())).mkString(",")).toString());
        return new GraphFrame(vertices, edges);
    }

    public GraphFrame fromEdges(Dataset<Row> e) {
        Dataset srcs = e.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{e.apply("src").as("id")}));
        Dataset dsts = e.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{e.apply("dst").as("id")}));
        Dataset v = srcs.unionAll(dsts).distinct();
        v.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        return this.apply((Dataset<Row>)v, e);
    }

    public <VD, ED> GraphFrame fromGraphX(Graph<VD, ED> graph, TypeTags.TypeTag<VD> evidence$1, TypeTags.TypeTag<ED> evidence$2) {
        SparkSession spark = SparkSession$.MODULE$.builder().getOrCreate();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_graphframes_GraphFrame$$typecreator1$1
        extends TypeCreator {
            private final TypeTags.TypeTag evidence$1$1;

            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("org.apache.spark.graphx").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.graphx.package")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("org.apache.spark.graphx.package").asModule().moduleClass(), "VertexId"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)this.evidence$1$1.in($m).tpe(), (List)Nil$.MODULE$)));
            }

            public Org_graphframes_GraphFrame$$typecreator1$1(TypeTags.TypeTag evidence$1$1) {
                this.evidence$1$1 = evidence$1$1;
            }
        }
        Dataset vv = spark.createDataFrame((RDD)graph.vertices(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_graphframes_GraphFrame$$typecreator1$1(evidence$1))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.ID(), this.ATTR()}));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Org_graphframes_GraphFrame$$typecreator2$1
        extends TypeCreator {
            private final TypeTags.TypeTag evidence$2$1;

            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("org.apache.spark.graphx").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("org.apache.spark.graphx.Edge"), (List)new .colon.colon((Object)this.evidence$2$1.in($m).tpe(), (List)Nil$.MODULE$));
            }

            public Org_graphframes_GraphFrame$$typecreator2$1(TypeTags.TypeTag evidence$2$1) {
                this.evidence$2$1 = evidence$2$1;
            }
        }
        Dataset ee = spark.createDataFrame((RDD)graph.edges(), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_graphframes_GraphFrame$$typecreator2$1(evidence$2))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.SRC(), this.DST(), this.ATTR()}));
        return this.apply((Dataset<Row>)vv, (Dataset<Row>)ee);
    }

    public <V, E> GraphFrame fromGraphX(GraphFrame originalGraph, Graph<V, E> graph, Seq<String> vertexNames, Seq<String> edgeNames, TypeTags.TypeTag<V> evidence$3, TypeTags.TypeTag<E> evidence$4) {
        return GraphXConversions$.MODULE$.fromGraphX(originalGraph, graph, vertexNames, edgeNames, evidence$3, evidence$4);
    }

    public <V, E> Seq<String> fromGraphX$default$3() {
        return Nil$.MODULE$;
    }

    public <V, E> Seq<String> fromGraphX$default$4() {
        return Nil$.MODULE$;
    }

    public String ATTR() {
        return this.ATTR;
    }

    public String LONG_ID() {
        return this.LONG_ID;
    }

    public String LONG_SRC() {
        return this.LONG_SRC;
    }

    public String LONG_DST() {
        return this.LONG_DST;
    }

    public String GX_ATTR() {
        return this.GX_ATTR;
    }

    public String quote(String column) {
        return new StringBuilder(2).append("`").append(column.replace("`", "``")).append("`").toString();
    }

    public String quote(Seq<String> columnSegments) {
        return ((TraversableOnce)columnSegments.map((Function1 & Serializable & scala.Serializable)column -> MODULE$.quote((String)column), Seq$.MODULE$.canBuildFrom())).mkString(".");
    }

    public Seq<String> colStar(Dataset<Row> df, String col) {
        DataType dataType = df.schema().apply(col).dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fieldNames())).map((Function1 & Serializable & scala.Serializable)f -> MODULE$.quote((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{col, f})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toIndexedSeq();
        }
        throw new RuntimeException(new StringBuilder(80).append("Unknown error in GraphFrame. Expected column ").append(col).append(" to be").append(" StructType, but found type: ").append(dataType).toString());
    }

    public Column nestAsCol(Dataset<Row> df, String name) {
        return functions$.MODULE$.struct(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])df.columns())).map((Function1 & Serializable & scala.Serializable)column -> MODULE$.quote((String)column), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).map((Function1 & Serializable & scala.Serializable)c -> df.apply(c), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).toSeq()).as(name);
    }

    private Random random() {
        return this.random;
    }

    private String prefixWithName(String name, String col) {
        return new StringBuilder(1).append(name).append(".").append(col).toString();
    }

    private String vId(String name) {
        return this.prefixWithName(name, this.ID());
    }

    private String eSrcId(String name) {
        return this.prefixWithName(name, this.SRC());
    }

    private String eDstId(String name) {
        return this.prefixWithName(name, this.DST());
    }

    private Dataset<Row> maybeCrossJoin(Option<Dataset<Row>> aOpt, Dataset<Row> b) {
        Option<Dataset<Row>> option = aOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            Dataset a = (Dataset)some.value();
            return a.crossJoin(b);
        }
        if (None$.MODULE$.equals(option)) {
            return b;
        }
        throw new MatchError(option);
    }

    private Dataset<Row> maybeJoin(Option<Dataset<Row>> aOpt, Dataset<Row> b, Function1<Dataset<Row>, Column> joinExprs) {
        Option<Dataset<Row>> option = aOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            Dataset a = (Dataset)some.value();
            return a.join(b, (Column)joinExprs.apply((Object)a));
        }
        if (None$.MODULE$.equals(option)) {
            return b;
        }
        throw new MatchError(option);
    }

    private boolean seen(NamedVertex v, Seq<Pattern> patterns) {
        return patterns.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)GraphFrame$.MODULE$.seen1(v, p)));
    }

    private boolean seen1(NamedVertex v, Pattern pattern) {
        Pattern pattern2;
        block6: {
            while (true) {
                if ((pattern2 = pattern) instanceof Negation) {
                    Negation negation = (Negation)pattern2;
                    Edge edge = negation.child();
                    pattern = edge;
                    continue;
                }
                if (pattern2 instanceof AnonymousEdge) {
                    AnonymousEdge anonymousEdge = (AnonymousEdge)pattern2;
                    Vertex src = anonymousEdge.src();
                    Vertex dst = anonymousEdge.dst();
                    if (!this.seen1(v, src)) {
                        pattern = dst;
                        continue;
                    }
                    return true;
                }
                if (!(pattern2 instanceof NamedEdge)) break block6;
                NamedEdge namedEdge = (NamedEdge)pattern2;
                Vertex src = namedEdge.src();
                Vertex dst = namedEdge.dst();
                if (this.seen1(v, src)) break;
                pattern = dst;
            }
            return true;
        }
        if (pattern2 instanceof NamedVertex) {
            NamedVertex namedVertex;
            NamedVertex namedVertex2 = namedVertex = (NamedVertex)pattern2;
            NamedVertex namedVertex3 = v;
            return !(namedVertex2 != null ? !((Object)namedVertex2).equals(namedVertex3) : namedVertex3 != null);
        }
        if (AnonymousVertex$.MODULE$.equals(pattern2)) {
            return false;
        }
        throw new MatchError((Object)pattern2);
    }

    public Tuple2<Option<Dataset<Row>>, Seq<String>> org$graphframes$GraphFrame$$findIncremental(GraphFrame gf, Seq<Pattern> prevPatterns, Option<Dataset<Row>> prev2, Seq<String> prevNames, Pattern pattern) {
        boolean bl = false;
        NamedEdge namedEdge = null;
        Pattern pattern2 = pattern;
        if (AnonymousVertex$.MODULE$.equals(pattern2)) {
            return new Tuple2(prev2, prevNames);
        }
        if (pattern2 instanceof NamedVertex) {
            NamedVertex namedVertex = (NamedVertex)pattern2;
            String name = namedVertex.name();
            if (this.seen(namedVertex, prevPatterns)) {
                prev2.foreach((Function1 & Serializable & scala.Serializable)prev -> {
                    Predef$.MODULE$.assert(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])prev.columns())).toSet().contains((Object)name));
                    return BoxedUnit.UNIT;
                });
                return new Tuple2(prev2, prevNames);
            }
            return new Tuple2((Object)new Some(this.maybeCrossJoin(prev2, (Dataset<Row>)this.nestV$1(name, gf))), prevNames.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom()));
        }
        if (pattern2 instanceof NamedEdge) {
            bl = true;
            namedEdge = (NamedEdge)pattern2;
            String name = namedEdge.name();
            Vertex vertex = namedEdge.src();
            Vertex vertex2 = namedEdge.dst();
            if (AnonymousVertex$.MODULE$.equals(vertex) && AnonymousVertex$.MODULE$.equals(vertex2)) {
                Dataset eRen = this.nestE$1(name, gf);
                return new Tuple2((Object)new Some(this.maybeCrossJoin(prev2, (Dataset<Row>)eRen)), prevNames.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom()));
            }
        }
        if (bl) {
            String name = namedEdge.name();
            Vertex vertex = namedEdge.src();
            Vertex dst = namedEdge.dst();
            if (AnonymousVertex$.MODULE$.equals(vertex) && dst instanceof NamedVertex) {
                NamedVertex namedVertex = (NamedVertex)dst;
                String dstName = namedVertex.name();
                if (this.seen(namedVertex, prevPatterns)) {
                    Dataset eRen = this.nestE$1(name, gf);
                    return new Tuple2((Object)new Some(this.maybeJoin(prev2, (Dataset<Row>)eRen, (Function1<Dataset<Row>, Column>)(Function1 & Serializable & scala.Serializable)prev -> eRen.apply(MODULE$.eDstId(name)).$eq$eq$eq((Object)prev.apply(MODULE$.vId(dstName))))), prevNames.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom()));
                }
                Dataset eRen = this.nestE$1(name, gf);
                Dataset dstV = this.nestV$1(dstName, gf);
                return new Tuple2((Object)new Some((Object)this.maybeCrossJoin(prev2, (Dataset<Row>)eRen).join(dstV, eRen.apply(this.eDstId(name)).$eq$eq$eq((Object)dstV.apply(this.vId(dstName))))), ((SeqLike)prevNames.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)dstName, Seq$.MODULE$.canBuildFrom()));
            }
        }
        if (bl) {
            String name = namedEdge.name();
            Vertex src = namedEdge.src();
            Vertex vertex = namedEdge.dst();
            if (src instanceof NamedVertex) {
                NamedVertex namedVertex = (NamedVertex)src;
                String srcName = namedVertex.name();
                if (AnonymousVertex$.MODULE$.equals(vertex)) {
                    if (this.seen(namedVertex, prevPatterns)) {
                        Dataset eRen = this.nestE$1(name, gf);
                        return new Tuple2((Object)new Some(this.maybeJoin(prev2, (Dataset<Row>)eRen, (Function1<Dataset<Row>, Column>)(Function1 & Serializable & scala.Serializable)prev -> eRen.apply(MODULE$.eSrcId(name)).$eq$eq$eq((Object)prev.apply(MODULE$.vId(srcName))))), prevNames.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom()));
                    }
                    Dataset eRen = this.nestE$1(name, gf);
                    Dataset srcV = this.nestV$1(srcName, gf);
                    return new Tuple2((Object)new Some((Object)this.maybeCrossJoin(prev2, (Dataset<Row>)eRen).join(srcV, eRen.apply(this.eSrcId(name)).$eq$eq$eq((Object)srcV.apply(this.vId(srcName))))), ((SeqLike)prevNames.$colon$plus((Object)srcName, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom()));
                }
            }
        }
        if (bl) {
            String name = namedEdge.name();
            Vertex src = namedEdge.src();
            Vertex dst = namedEdge.dst();
            if (src instanceof NamedVertex) {
                NamedVertex namedVertex = (NamedVertex)src;
                String srcName = namedVertex.name();
                if (dst instanceof NamedVertex) {
                    NamedVertex namedVertex2 = (NamedVertex)dst;
                    String dstName = namedVertex2.name();
                    Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(this.seen(namedVertex, prevPatterns), this.seen(namedVertex2, prevPatterns));
                    if (sp2 != null) {
                        boolean bl2 = sp2._1$mcZ$sp();
                        boolean bl3 = sp2._2$mcZ$sp();
                        if (bl2 && bl3) {
                            Dataset eRen = this.nestE$1(name, gf);
                            return new Tuple2((Object)new Some(this.maybeJoin(prev2, (Dataset<Row>)eRen, (Function1<Dataset<Row>, Column>)(Function1 & Serializable & scala.Serializable)prev -> eRen.apply(MODULE$.eSrcId(name)).$eq$eq$eq((Object)prev.apply(MODULE$.vId(srcName))).$amp$amp((Object)eRen.apply(MODULE$.eDstId(name)).$eq$eq$eq((Object)prev.apply(MODULE$.vId(dstName)))))), prevNames.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom()));
                        }
                    }
                    if (sp2 != null) {
                        boolean bl4 = sp2._1$mcZ$sp();
                        boolean bl5 = sp2._2$mcZ$sp();
                        if (bl4 && !bl5) {
                            Dataset eRen = this.nestE$1(name, gf);
                            Dataset dstV = this.nestV$1(dstName, gf);
                            return new Tuple2((Object)new Some((Object)this.maybeJoin(prev2, (Dataset<Row>)eRen, (Function1<Dataset<Row>, Column>)(Function1 & Serializable & scala.Serializable)prev -> eRen.apply(MODULE$.eSrcId(name)).$eq$eq$eq((Object)prev.apply(MODULE$.vId(srcName)))).join(dstV, eRen.apply(this.eDstId(name)).$eq$eq$eq((Object)dstV.apply(this.vId(dstName))))), ((SeqLike)prevNames.$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)dstName, Seq$.MODULE$.canBuildFrom()));
                        }
                    }
                    if (sp2 != null) {
                        boolean bl6 = sp2._1$mcZ$sp();
                        boolean bl7 = sp2._2$mcZ$sp();
                        if (!bl6 && bl7) {
                            Dataset eRen = this.nestE$1(name, gf);
                            Dataset srcV = this.nestV$1(srcName, gf);
                            return new Tuple2((Object)new Some((Object)this.maybeJoin(prev2, (Dataset<Row>)eRen, (Function1<Dataset<Row>, Column>)(Function1 & Serializable & scala.Serializable)prev -> eRen.apply(MODULE$.eDstId(name)).$eq$eq$eq((Object)prev.apply(MODULE$.vId(dstName)))).join(srcV, eRen.apply(this.eSrcId(name)).$eq$eq$eq((Object)srcV.apply(this.vId(srcName))))), ((SeqLike)prevNames.$colon$plus((Object)srcName, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom()));
                        }
                    }
                    if (sp2 != null) {
                        boolean bl8 = sp2._1$mcZ$sp();
                        boolean bl9 = sp2._2$mcZ$sp();
                        if (!bl8 && !bl9) {
                            String string = srcName;
                            String string2 = dstName;
                            if (string == null ? string2 != null : !string.equals(string2)) {
                                Dataset eRen = this.nestE$1(name, gf);
                                Dataset srcV = this.nestV$1(srcName, gf);
                                Dataset dstV = this.nestV$1(dstName, gf);
                                return new Tuple2((Object)new Some((Object)this.maybeCrossJoin(prev2, (Dataset<Row>)eRen).join(srcV, eRen.apply(this.eSrcId(name)).$eq$eq$eq((Object)srcV.apply(this.vId(srcName)))).join(dstV, eRen.apply(this.eDstId(name)).$eq$eq$eq((Object)dstV.apply(this.vId(dstName))))), ((SeqLike)((SeqLike)prevNames.$colon$plus((Object)srcName, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)dstName, Seq$.MODULE$.canBuildFrom()));
                            }
                        }
                    }
                    if (sp2 != null) {
                        boolean bl10 = sp2._1$mcZ$sp();
                        boolean bl11 = sp2._2$mcZ$sp();
                        if (!bl10 && !bl11) {
                            String string = srcName;
                            String string3 = dstName;
                            if (!(string != null ? !string.equals(string3) : string3 != null)) {
                                Dataset eRen = this.nestE$1(name, gf);
                                Dataset srcV = this.nestV$1(srcName, gf);
                                return new Tuple2((Object)new Some((Object)this.maybeCrossJoin(prev2, (Dataset<Row>)eRen).join(srcV, eRen.apply(this.eSrcId(name)).$eq$eq$eq((Object)srcV.apply(this.vId(srcName))).$amp$amp((Object)eRen.apply(this.eDstId(name)).$eq$eq$eq((Object)srcV.apply(this.vId(srcName)))))), ((SeqLike)prevNames.$colon$plus((Object)srcName, Seq$.MODULE$.canBuildFrom())).$colon$plus((Object)name, Seq$.MODULE$.canBuildFrom()));
                            }
                        }
                    }
                    throw new GraphFramesUnreachableException();
                }
            }
        }
        if (pattern2 instanceof AnonymousEdge) {
            AnonymousEdge anonymousEdge = (AnonymousEdge)pattern2;
            Vertex src = anonymousEdge.src();
            Vertex dst = anonymousEdge.dst();
            String tmpName = new StringBuilder(5).append("__tmp").append(Long.toString(this.random().nextLong())).toString();
            Tuple2<Option<Dataset<Row>>, Seq<String>> tuple2 = this.org$graphframes$GraphFrame$$findIncremental(gf, prevPatterns, prev2, prevNames, new NamedEdge(tmpName, src, dst));
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option df = (Option)tuple2._1();
            Seq names = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)df, (Object)names);
            Option df2 = (Option)tuple22._1();
            Seq names2 = (Seq)tuple22._2();
            return new Tuple2((Object)df2.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.drop(tmpName)), names2.filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)GraphFrame$.$anonfun$findIncremental$8(tmpName, x$12))));
        }
        if (pattern2 instanceof Negation) {
            Negation negation = (Negation)pattern2;
            Edge edge = negation.child();
            Option<Dataset<Row>> option = prev2;
            if (option instanceof Some) {
                Some some = (Some)option;
                Dataset p = (Dataset)some.value();
                Tuple2<Option<Dataset<Row>>, Seq<String>> tuple2 = this.org$graphframes$GraphFrame$$findIncremental(gf, prevPatterns, (Option<Dataset<Row>>)new Some((Object)p), prevNames, edge);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Option df = (Option)tuple2._1();
                Seq names = (Seq)tuple2._2();
                Tuple2 tuple23 = new Tuple2((Object)df, (Object)names);
                Option df3 = (Option)tuple23._1();
                Seq names3 = (Seq)tuple23._2();
                return new Tuple2((Object)df3.map((Function1 & Serializable & scala.Serializable)result -> p.except(result)), (Object)names3);
            }
            if (None$.MODULE$.equals(option)) {
                throw new InvalidPatternException();
            }
            throw new MatchError(option);
        }
        throw new MatchError((Object)pattern2);
    }

    public int broadcastThreshold() {
        return this._broadcastThreshold;
    }

    public GraphFrame$ setBroadcastThreshold(int value) {
        Predef$.MODULE$.require(value >= 0);
        this._broadcastThreshold = value;
        return this;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final Dataset nestE$1(String name, GraphFrame gf$1) {
        return gf$1.edges().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.nestAsCol(gf$1.edges(), name)}));
    }

    private final Dataset nestV$1(String name, GraphFrame gf$1) {
        return gf$1.vertices().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.nestAsCol(gf$1.vertices(), name)}));
    }

    public static final /* synthetic */ boolean $anonfun$findIncremental$8(String tmpName$1, String x$12) {
        String string = x$12;
        String string2 = tmpName$1;
        return string == null ? string2 != null : !string.equals(string2);
    }

    private GraphFrame$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.ID = "id";
        this.SRC = "src";
        this.DST = "dst";
        this.EDGE = "edge";
        this.WEIGHT = "weight";
        this.ATTR = "attr";
        this.LONG_ID = "new_id";
        this.LONG_SRC = "new_src";
        this.LONG_DST = "new_dst";
        this.GX_ATTR = "graphx_attr";
        this.random = new Random(Statics.anyHash((Object)GraphFrame.class.getName()));
        this._broadcastThreshold = 1000000;
    }
}

