/*
 * Decompiled with CFR 0.152.
 */
package org.graphframes.examples;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.sys.process.package$;

public final class LDBCUtils$ {
    public static LDBCUtils$ MODULE$;
    private final String LDBC_URL_PREFIX;
    private final int bufferSize;
    private final String TEST_BFS_DIRECTED;
    private final String TEST_BFS_UNDIRECTED;
    private final String TEST_CDLP_DIRECTED;
    private final String TEST_CDLP_UNDIRECTED;
    private final String TEST_PR_DIRECTED;
    private final String TEST_PR_UNDIRECTED;
    private final String TEST_WCC_DIRECTED;
    private final String TEST_WCC_UNDIRECTED;
    private final String KGS;
    private final String GRAPH500_22;
    private final String GRAPH500_24;
    private final String CIT_PATENTS;
    private final String WIKI_TALKS;
    private final Set<String> possibleCaseNames;

    static {
        new LDBCUtils$();
    }

    private String LDBC_URL_PREFIX() {
        return this.LDBC_URL_PREFIX;
    }

    private int bufferSize() {
        return this.bufferSize;
    }

    public String TEST_BFS_DIRECTED() {
        return this.TEST_BFS_DIRECTED;
    }

    public String TEST_BFS_UNDIRECTED() {
        return this.TEST_BFS_UNDIRECTED;
    }

    public String TEST_CDLP_DIRECTED() {
        return this.TEST_CDLP_DIRECTED;
    }

    public String TEST_CDLP_UNDIRECTED() {
        return this.TEST_CDLP_UNDIRECTED;
    }

    public String TEST_PR_DIRECTED() {
        return this.TEST_PR_DIRECTED;
    }

    public String TEST_PR_UNDIRECTED() {
        return this.TEST_PR_UNDIRECTED;
    }

    public String TEST_WCC_DIRECTED() {
        return this.TEST_WCC_DIRECTED;
    }

    public String TEST_WCC_UNDIRECTED() {
        return this.TEST_WCC_UNDIRECTED;
    }

    public String KGS() {
        return this.KGS;
    }

    public String GRAPH500_22() {
        return this.GRAPH500_22;
    }

    public String GRAPH500_24() {
        return this.GRAPH500_24;
    }

    public String CIT_PATENTS() {
        return this.CIT_PATENTS;
    }

    public String WIKI_TALKS() {
        return this.WIKI_TALKS;
    }

    private Set<String> possibleCaseNames() {
        return this.possibleCaseNames;
    }

    private URL ldbcURL(String caseName) {
        return new URL(new StringBuilder(8).append(this.LDBC_URL_PREFIX()).append(caseName).append(".tar.zst").toString());
    }

    private void checkZSTD() {
        try {
            int version = package$.MODULE$.stringToProcess("zstd --version").$bang();
            Predef$.MODULE$.println((Object)new StringBuilder(20).append("found zstd version: ").append(version).toString());
        }
        catch (Exception e) {
            throw new RuntimeException("zstd is not available or not found. Please install zstd and try again.", e);
        }
    }

    private void checkName(String name) {
        Predef$.MODULE$.require(this.possibleCaseNames().contains((Object)name), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(24).append("Wrong ").append(name).append(", possible names: ").append(MODULE$.possibleCaseNames().mkString(", ")).toString());
    }

    public void downloadLDBCIfNotExists(Path path, String name) {
        this.checkName(name);
        Path dir = path.resolve(name);
        if (Files.notExists(dir, new LinkOption[0]) || Files.list(dir).count() == 0L) {
            Predef$.MODULE$.println((Object)new StringBuilder(49).append("LDBC data for the case ").append(name).append(" not found. Downloading...").toString());
            this.checkZSTD();
            Object object = Files.notExists(dir, new LinkOption[0]) ? Files.createDirectory(dir, new FileAttribute[0]) : BoxedUnit.UNIT;
            Path archivePath = path.resolve(new StringBuilder(8).append(name).append(".tar.zst").toString());
            URLConnection connection = this.ldbcURL(name).openConnection();
            InputStream inputStream = connection.getInputStream();
            OutputStream outputStream = Files.newOutputStream(archivePath, new OpenOption[0]);
            byte[] buffer = new byte[this.bufferSize()];
            int bytesRead = 0;
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            inputStream.close();
            outputStream.close();
            Predef$.MODULE$.println((Object)new StringBuilder(21).append("Uncompressing ").append(((Object)archivePath).toString()).append(" to ").append(((Object)dir).toString()).append("...").toString());
            package$.MODULE$.stringToProcess(new StringBuilder(12).append("zstd -d ").append(((Object)archivePath).toString()).append(" -o ").append(((Object)archivePath).toString().replace(".zst", "")).toString()).$bang();
            package$.MODULE$.stringToProcess(new StringBuilder(12).append("tar -xf ").append(((Object)archivePath).toString().replace(".zst", "")).append(" -C ").append(((Object)dir).toString()).toString()).$bang();
            Files.delete(archivePath);
            Files.delete(Paths.get(((Object)archivePath).toString().replace(".zst", ""), new String[0]));
            return;
        }
    }

    private LDBCUtils$() {
        MODULE$ = this;
        this.LDBC_URL_PREFIX = "https://datasets.ldbcouncil.org/graphalytics/";
        this.bufferSize = 8192;
        this.TEST_BFS_DIRECTED = "test-bfs-directed";
        this.TEST_BFS_UNDIRECTED = "test-bfs-undirected";
        this.TEST_CDLP_DIRECTED = "test-cdlp-directed";
        this.TEST_CDLP_UNDIRECTED = "test-cdlp-undirected";
        this.TEST_PR_DIRECTED = "test-pr-directed";
        this.TEST_PR_UNDIRECTED = "test-pr-undirected";
        this.TEST_WCC_DIRECTED = "test-wcc-directed";
        this.TEST_WCC_UNDIRECTED = "test-wcc-undirected";
        this.KGS = "kgs";
        this.GRAPH500_22 = "graph500-22";
        this.GRAPH500_24 = "graph500-24";
        this.CIT_PATENTS = "cit-Patents";
        this.WIKI_TALKS = "wiki-Talk";
        this.possibleCaseNames = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.TEST_BFS_DIRECTED(), this.TEST_BFS_UNDIRECTED(), this.TEST_CDLP_DIRECTED(), this.TEST_CDLP_UNDIRECTED(), this.TEST_PR_DIRECTED(), this.TEST_PR_UNDIRECTED(), this.TEST_WCC_DIRECTED(), this.TEST_WCC_UNDIRECTED(), this.KGS(), this.GRAPH500_22(), this.GRAPH500_24(), this.CIT_PATENTS(), this.WIKI_TALKS()}));
    }
}

