/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.cockpit.connectors.ws.endpoints;

import java.net.URI;

public class WebSocketEndpoint {
    private static final String HTTPS_SCHEME = "https";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private final String url;
    private final URI uri;
    private int retryCount;

    public WebSocketEndpoint(String url) {
        this.url = url;
        this.uri = URI.create(url);
        this.retryCount = 0;
    }

    public int incrementRetryCount() {
        ++this.retryCount;
        return this.retryCount;
    }

    public void reinitRetryCount() {
        this.retryCount = 0;
    }

    public int getPort() {
        return this.uri.getPort() != -1 ? this.uri.getPort() : (HTTPS_SCHEME.equals(this.uri.getScheme()) ? 443 : 80);
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public String resolvePath(String path) {
        return this.uri.resolve(path).getRawPath();
    }

    public boolean isRemovable() {
        return false;
    }

    public String getUrl() {
        return this.url;
    }

    public int getRetryCount() {
        return this.retryCount;
    }
}

