/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.cockpit.connectors.ws.http;

import io.gravitee.cockpit.connectors.ws.endpoints.WebSocketEndpoint;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;

public class HttpClientConfiguration {
    private final Environment environment;
    private List<WebSocketEndpoint> endpoints;
    @Value(value="${cockpit.keystore.type:#{null}}")
    private String keystoreType;
    @Value(value="${cockpit.keystore.path:#{null}}")
    private String keystorePath;
    @Value(value="${cockpit.keystore.password:#{null}}")
    private String keystorePassword;
    @Value(value="${cockpit.ssl.trustall:false}")
    private boolean trustAll;
    @Value(value="${cockpit.ssl.verifyHostname:true}")
    private boolean hostnameVerifier;
    @Value(value="${cockpit.truststore.type:#{null}}")
    private String truststoreType;
    @Value(value="${cockpit.truststore.path:#{null}}")
    private String truststorePath;
    @Value(value="${cockpit.truststore.password:#{null}}")
    private String truststorePassword;

    public List<WebSocketEndpoint> getEndpoints() {
        if (this.endpoints == null) {
            this.endpoints = this.initializeEndpoints();
        }
        return this.endpoints;
    }

    public void setEndpoints(List<WebSocketEndpoint> endpoints) {
        this.endpoints = endpoints;
    }

    private List<WebSocketEndpoint> initializeEndpoints() {
        String key = String.format("cockpit.ws.endpoints[%s]", 0);
        ArrayList<WebSocketEndpoint> endpoints = new ArrayList<WebSocketEndpoint>();
        while (this.environment.containsProperty(key)) {
            String url = this.environment.getProperty(key);
            endpoints.add(new WebSocketEndpoint(url));
            key = String.format("cockpit.ws.endpoints[%s]", endpoints.size());
        }
        return endpoints;
    }

    public HttpClientConfiguration(Environment environment) {
        this.environment = environment;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public String getKeystoreType() {
        return this.keystoreType;
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public boolean isHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public String getTruststoreType() {
        return this.truststoreType;
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public void setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public void setHostnameVerifier(boolean hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setTruststoreType(String truststoreType) {
        this.truststoreType = truststoreType;
    }

    public void setTruststorePath(String truststorePath) {
        this.truststorePath = truststorePath;
    }

    public void setTruststorePassword(String truststorePassword) {
        this.truststorePassword = truststorePassword;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpClientConfiguration)) {
            return false;
        }
        HttpClientConfiguration other = (HttpClientConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTrustAll() != other.isTrustAll()) {
            return false;
        }
        if (this.isHostnameVerifier() != other.isHostnameVerifier()) {
            return false;
        }
        Environment this$environment = this.getEnvironment();
        Environment other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        List<WebSocketEndpoint> this$endpoints = this.getEndpoints();
        List<WebSocketEndpoint> other$endpoints = other.getEndpoints();
        if (this$endpoints == null ? other$endpoints != null : !((Object)this$endpoints).equals(other$endpoints)) {
            return false;
        }
        String this$keystoreType = this.getKeystoreType();
        String other$keystoreType = other.getKeystoreType();
        if (this$keystoreType == null ? other$keystoreType != null : !this$keystoreType.equals(other$keystoreType)) {
            return false;
        }
        String this$keystorePath = this.getKeystorePath();
        String other$keystorePath = other.getKeystorePath();
        if (this$keystorePath == null ? other$keystorePath != null : !this$keystorePath.equals(other$keystorePath)) {
            return false;
        }
        String this$keystorePassword = this.getKeystorePassword();
        String other$keystorePassword = other.getKeystorePassword();
        if (this$keystorePassword == null ? other$keystorePassword != null : !this$keystorePassword.equals(other$keystorePassword)) {
            return false;
        }
        String this$truststoreType = this.getTruststoreType();
        String other$truststoreType = other.getTruststoreType();
        if (this$truststoreType == null ? other$truststoreType != null : !this$truststoreType.equals(other$truststoreType)) {
            return false;
        }
        String this$truststorePath = this.getTruststorePath();
        String other$truststorePath = other.getTruststorePath();
        if (this$truststorePath == null ? other$truststorePath != null : !this$truststorePath.equals(other$truststorePath)) {
            return false;
        }
        String this$truststorePassword = this.getTruststorePassword();
        String other$truststorePassword = other.getTruststorePassword();
        return !(this$truststorePassword == null ? other$truststorePassword != null : !this$truststorePassword.equals(other$truststorePassword));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpClientConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTrustAll() ? 79 : 97);
        result = result * 59 + (this.isHostnameVerifier() ? 79 : 97);
        Environment $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        List<WebSocketEndpoint> $endpoints = this.getEndpoints();
        result = result * 59 + ($endpoints == null ? 43 : ((Object)$endpoints).hashCode());
        String $keystoreType = this.getKeystoreType();
        result = result * 59 + ($keystoreType == null ? 43 : $keystoreType.hashCode());
        String $keystorePath = this.getKeystorePath();
        result = result * 59 + ($keystorePath == null ? 43 : $keystorePath.hashCode());
        String $keystorePassword = this.getKeystorePassword();
        result = result * 59 + ($keystorePassword == null ? 43 : $keystorePassword.hashCode());
        String $truststoreType = this.getTruststoreType();
        result = result * 59 + ($truststoreType == null ? 43 : $truststoreType.hashCode());
        String $truststorePath = this.getTruststorePath();
        result = result * 59 + ($truststorePath == null ? 43 : $truststorePath.hashCode());
        String $truststorePassword = this.getTruststorePassword();
        result = result * 59 + ($truststorePassword == null ? 43 : $truststorePassword.hashCode());
        return result;
    }

    public String toString() {
        return "HttpClientConfiguration(environment=" + this.getEnvironment() + ", endpoints=" + this.getEndpoints() + ", keystoreType=" + this.getKeystoreType() + ", keystorePath=" + this.getKeystorePath() + ", keystorePassword=" + this.getKeystorePassword() + ", trustAll=" + this.isTrustAll() + ", hostnameVerifier=" + this.isHostnameVerifier() + ", truststoreType=" + this.getTruststoreType() + ", truststorePath=" + this.getTruststorePath() + ", truststorePassword=" + this.getTruststorePassword() + ")";
    }
}

