/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.cockpit.connectors.ws.http;

import io.gravitee.cockpit.connectors.ws.endpoints.WebSocketEndpoint;
import io.gravitee.cockpit.connectors.ws.http.HttpClientConfiguration;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import java.net.URI;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(HttpClientFactory.class);
    private static final String HTTPS_SCHEME = "https";
    private static final String KEYSTORE_FORMAT_JKS = "JKS";
    private static final String KEYSTORE_FORMAT_PEM = "PEM";
    private static final String KEYSTORE_FORMAT_PKCS12 = "PKCS12";
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Vertx vertx;
    private final HttpClientConfiguration configuration;

    public HttpClientFactory(Vertx vertx, HttpClientConfiguration configuration) {
        this.vertx = vertx;
        this.configuration = configuration;
    }

    public WebSocketEndpoint nextEndpoint() {
        List<WebSocketEndpoint> endpoints = this.configuration.getEndpoints();
        if (endpoints.isEmpty()) {
            return null;
        }
        WebSocketEndpoint endpoint = endpoints.get(Math.abs(this.counter.getAndIncrement() % endpoints.size()));
        int tryConnect = endpoint.incrementRetryCount();
        if (tryConnect > 5 && endpoint.isRemovable()) {
            log.info("Cockpit connector tries to connect to instance at {} 5 times. Removing instance...", (Object)endpoint.getUrl());
            this.configuration.getEndpoints().remove(endpoint);
            return this.nextEndpoint();
        }
        return endpoint;
    }

    public HttpClient getHttpClient(WebSocketEndpoint webSocketEndpoint) {
        URI target = URI.create(webSocketEndpoint.getUrl());
        HttpClientOptions options = new HttpClientOptions();
        if (!HTTPS_SCHEME.equalsIgnoreCase(target.getScheme())) {
            throw new IllegalArgumentException("Https is mandatory");
        }
        options.setSsl(true);
        options.setTrustAll(this.configuration.isTrustAll());
        options.setVerifyHost(this.configuration.isHostnameVerifier());
        if (this.configuration.getKeystoreType() != null) {
            if (this.configuration.getKeystoreType().equalsIgnoreCase(KEYSTORE_FORMAT_JKS)) {
                options.setKeyStoreOptions(new JksOptions().setPath(this.configuration.getKeystorePath()).setPassword(this.configuration.getKeystorePassword()));
            } else if (this.configuration.getKeystoreType().equalsIgnoreCase(KEYSTORE_FORMAT_PKCS12)) {
                options.setPfxKeyCertOptions(new PfxOptions().setPath(this.configuration.getKeystorePath()).setPassword(this.configuration.getKeystorePassword()));
            }
        }
        if (this.configuration.getTruststoreType() != null) {
            if (this.configuration.getTruststoreType().equalsIgnoreCase(KEYSTORE_FORMAT_JKS)) {
                options.setTrustStoreOptions(new JksOptions().setPath(this.configuration.getTruststorePath()).setPassword(this.configuration.getTruststorePassword()));
            } else if (this.configuration.getTruststoreType().equalsIgnoreCase(KEYSTORE_FORMAT_PKCS12)) {
                options.setPfxTrustOptions(new PfxOptions().setPath(this.configuration.getTruststorePath()).setPassword(this.configuration.getTruststorePassword()));
            } else if (this.configuration.getTruststoreType().equalsIgnoreCase(KEYSTORE_FORMAT_PEM)) {
                options.setPemTrustOptions(new PemTrustOptions().addCertPath(this.configuration.getTruststorePath()));
            }
        }
        return this.vertx.createHttpClient(options);
    }

    public HttpClientConfiguration getConfiguration() {
        return this.configuration;
    }
}

