/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.cockpit.connectors.ws.spring;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.gravitee.cockpit.connectors.core.spring.CommandHandlersConfiguration;
import io.gravitee.cockpit.connectors.core.spring.MonitoringCollectorConfiguration;
import io.gravitee.cockpit.connectors.ws.http.HttpClientConfiguration;
import io.gravitee.cockpit.connectors.ws.http.HttpClientFactory;
import io.gravitee.plugin.core.api.PluginManifest;
import io.gravitee.plugin.core.api.PluginRegistry;
import io.vertx.core.Vertx;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration
@Import(value={CommandHandlersConfiguration.class, MonitoringCollectorConfiguration.class})
public class WebSocketConnectorConfiguration {
    public static final String COCKPIT_CONNECTORS_WS_PLUGIN_ID = "cockpit-connectors-ws";

    @Bean
    public HttpClientConfiguration httpClientConfiguration(Environment environment) {
        return new HttpClientConfiguration(environment);
    }

    @Bean
    public HttpClientFactory httpClientFactory(Vertx vertx, HttpClientConfiguration configuration) {
        return new HttpClientFactory(vertx, configuration);
    }

    @Bean(value={"pluginManifest"})
    PluginManifest pluginInfos(PluginRegistry pluginRegistry) {
        return pluginRegistry.plugins().stream().filter(plugin -> plugin.id().equals(COCKPIT_CONNECTORS_WS_PLUGIN_ID)).findFirst().get().manifest();
    }

    @Bean(value={"cockpitObjectMapper"})
    public ObjectMapper objectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES);
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return mapper;
    }
}

