/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.http;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;
import org.springframework.util.InvalidMimeTypeException;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;

public class MediaType {
    private final String type;
    private final String subtype;
    private final Map<String, String> parameters;
    public static final String CHARSET_PARAMETER = "charset";
    public static final String MEDIA_TYPE_WILDCARD = "*";
    public static final String WILDCARD = "*/*";
    public static final MediaType MEDIA_ALL = new MediaType("*", "*");
    public static final String APPLICATION_XML = "application/xml";
    public static final MediaType MEDIA_APPLICATION_XML = new MediaType("application", "xml");
    public static final String APPLICATION_ATOM_XML = "application/atom+xml";
    public static final MediaType MEDIA_APPLICATION_ATOM_XML = new MediaType("application", "atom+xml");
    public static final String APPLICATION_XHTML_XML = "application/xhtml+xml";
    public static final MediaType MEDIA_APPLICATION_XHTML_XML = new MediaType("application", "xhtml+xml");
    public static final String APPLICATION_SVG_XML = "application/svg+xml";
    public static final MediaType MEDIA_APPLICATION_SVG_XML = new MediaType("application", "svg+xml");
    public static final String APPLICATION_JSON = "application/json";
    public static final MediaType MEDIA_APPLICATION_JSON = new MediaType("application", "json");
    public static final String APPLICATION_JWT = "application/jwt";
    public static final MediaType MEDIA_APPLICATION_JWT = new MediaType("application", "jwt");
    public static final String APPLICATION_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final MediaType MEDIA_APPLICATION_FORM_URLENCODED = new MediaType("application", "x-www-form-urlencoded");
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    public static final MediaType MEDIA_MULTIPART_FORM_DATA = new MediaType("multipart", "form-data");
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final MediaType MEDIA_APPLICATION_OCTET_STREAM = new MediaType("application", "octet-stream");
    public static final String TEXT_PLAIN = "text/plain";
    public static final MediaType MEDIA_TEXT_PLAIN = new MediaType("text", "plain");
    public static final String TEXT_XML = "text/xml";
    public static final MediaType MEDIA_TEXT_XML = new MediaType("text", "xml");
    public static final String TEXT_HTML = "text/html";
    public static final MediaType MEDIA_TEXT_HTML = new MediaType("text", "html");
    public static final String TEXT_EVENT_STREAM = "text/event-stream";
    public static final MediaType MEDIA_TEXT_EVENT_STREAM = new MediaType("text", "event-stream");
    public String QUALITY_FACTOR_PARAMETER = "q";
    public static final Comparator<MediaType> QUALITY_FACTOR_COMPARATOR = (mediaType1, mediaType2) -> {
        double quality1 = mediaType1.getQualityFactor();
        double quality2 = mediaType2.getQualityFactor();
        int qualityComparison = Double.compare(quality2, quality1);
        if (qualityComparison != 0) {
            return qualityComparison;
        }
        if (mediaType1.isWildcardType() && !mediaType2.isWildcardType()) {
            return 1;
        }
        if (mediaType2.isWildcardType() && !mediaType1.isWildcardType()) {
            return -1;
        }
        if (!mediaType1.getType().equals(mediaType2.getType())) {
            return 0;
        }
        if (mediaType1.isWildcardSubtype() && !mediaType2.isWildcardSubtype()) {
            return 1;
        }
        if (mediaType2.isWildcardSubtype() && !mediaType1.isWildcardSubtype()) {
            return -1;
        }
        if (!mediaType1.getSubtype().equals(mediaType2.getSubtype())) {
            return 0;
        }
        int paramsSize1 = mediaType1.getParameters().size();
        int paramsSize2 = mediaType2.getParameters().size();
        return Integer.compare(paramsSize2, paramsSize1);
    };

    public MediaType(String type, String subtype) {
        this(type, subtype, Collections.emptyMap());
    }

    public MediaType(String type, String subtype, Map<String, String> parameters) {
        this.type = type;
        this.subtype = subtype;
        this.parameters = parameters;
    }

    public boolean isWildcardType() {
        return MEDIA_TYPE_WILDCARD.equals(this.getType());
    }

    public boolean isWildcardSubtype() {
        return MEDIA_TYPE_WILDCARD.equals(this.getSubtype()) || this.getSubtype().startsWith("*+");
    }

    public boolean isConcrete() {
        return !this.isWildcardType() && !this.isWildcardSubtype();
    }

    public String getType() {
        return this.type;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public Charset getCharset() {
        String charset = this.getParameter(CHARSET_PARAMETER);
        return charset != null ? Charset.forName(this.unquote(charset)) : null;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    private boolean isQuotedString(String s) {
        if (s.length() < 2) {
            return false;
        }
        return s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'");
    }

    protected String unquote(String s) {
        return this.isQuotedString(s) ? s.substring(1, s.length() - 1) : s;
    }

    public double getQualityFactor() {
        String qualityFactor = this.getParameter(this.QUALITY_FACTOR_PARAMETER);
        return qualityFactor != null ? Double.parseDouble(this.unquote(qualityFactor)) : 1.0;
    }

    public static List<MediaType> parseMediaTypes(List<String> mediaTypes) {
        if (CollectionUtils.isEmpty(mediaTypes)) {
            return Collections.emptyList();
        }
        if (mediaTypes.size() == 1) {
            return MediaType.parseMediaTypes(mediaTypes.get(0));
        }
        ArrayList<MediaType> result = new ArrayList<MediaType>(8);
        for (String mediaType : mediaTypes) {
            result.addAll(MediaType.parseMediaTypes(mediaType));
        }
        return result;
    }

    public static List<MediaType> parseMediaTypes(String mediaTypes) {
        if (mediaTypes == null || mediaTypes.isEmpty()) {
            return Collections.emptyList();
        }
        List tokenizedTypes = MimeTypeUtils.tokenize((String)mediaTypes);
        ArrayList<MediaType> result = new ArrayList<MediaType>(tokenizedTypes.size());
        for (String type : tokenizedTypes) {
            if (!StringUtils.hasText((String)type)) continue;
            result.add(MediaType.parseMediaType(type));
        }
        return result;
    }

    public static MediaType parseMediaType(String mediaType) {
        MimeType type;
        try {
            type = MimeTypeUtils.parseMimeType((String)mediaType);
        }
        catch (InvalidMimeTypeException var4) {
            return null;
        }
        try {
            return new MediaType(type.getType(), type.getSubtype(), type.getParameters());
        }
        catch (IllegalArgumentException var3) {
            return null;
        }
    }

    public static void sortByQualityValue(List<MediaType> mediaTypes) {
        if (mediaTypes != null && mediaTypes.size() > 1) {
            mediaTypes.sort(QUALITY_FACTOR_COMPARATOR);
        }
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.subtype.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaType)) {
            return false;
        }
        MediaType otherType = (MediaType)other;
        return this.type.equalsIgnoreCase(otherType.type) && this.subtype.equalsIgnoreCase(otherType.subtype);
    }

    public String toMediaString() {
        return this.type + '/' + this.subtype;
    }
}

