/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.common.util;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class DataEncryptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataEncryptor.class);
    private static final String AES_ALGORITHM = "AES";
    private String secret;

    public DataEncryptor(Environment environment, String secretPropertyKey, String defaultSecret) {
        this.secret = environment.getProperty(secretPropertyKey, defaultSecret);
        if (defaultSecret.equals(this.secret)) {
            LOGGER.warn("");
            LOGGER.warn("##############################################################");
            LOGGER.warn("#                      SECURITY WARNING                      #");
            LOGGER.warn("##############################################################");
            LOGGER.warn("");
            LOGGER.warn("You still use the default secret.");
            LOGGER.warn("This known secret can be used to access protected information.");
            LOGGER.warn("Please customize the '{}' parameter value, or ask your administrator to do it.", (Object)secretPropertyKey);
            LOGGER.warn("");
            LOGGER.warn("##############################################################");
            LOGGER.warn("");
        }
    }

    public String encrypt(String value) throws GeneralSecurityException {
        byte[] encrypted = this.buildCipher(1).doFinal(value.getBytes());
        return Base64.getEncoder().encodeToString(encrypted);
    }

    public String decrypt(String base64value) throws GeneralSecurityException {
        byte[] decrypted = this.buildCipher(2).doFinal(Base64.getDecoder().decode(base64value));
        return new String(decrypted);
    }

    private Cipher buildCipher(int cipherMode) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
        cipher.init(cipherMode, (Key)this.toSecretKeySpec(this.secret), cipher.getParameters());
        return cipher;
    }

    private SecretKeySpec toSecretKeySpec(String secret) {
        return new SecretKeySpec(secret.getBytes(), AES_ALGORITHM);
    }
}

