/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.discovery.consul.service;

import io.gravitee.discovery.api.service.Service;
import java.util.Objects;

public class ConsulService
implements Service {
    private static final String CONSUL_ID_PREFIX = "consul:";
    private static final String CONSUL_SSL_METADATA = "gravitee_ssl";
    private static final String CONSUL_PATH_METADATA = "gravitee_path";
    private final io.vertx.ext.consul.Service service;
    private final String address;
    private final String id;
    private String scheme = "http";
    private String path = "/";

    public ConsulService(io.vertx.ext.consul.Service service) {
        String pathMetadata;
        String sslMetadata;
        this.service = service;
        this.address = service.getAddress() == null || service.getAddress().trim().isEmpty() ? service.getNodeAddress() : service.getAddress();
        this.id = CONSUL_ID_PREFIX + service.getId();
        String string = sslMetadata = service.getMeta() != null ? (String)service.getMeta().get(CONSUL_SSL_METADATA) : null;
        if (Boolean.parseBoolean(sslMetadata)) {
            this.scheme = "https";
        }
        String string2 = pathMetadata = service.getMeta() != null ? (String)service.getMeta().get(CONSUL_PATH_METADATA) : null;
        if (pathMetadata != null) {
            this.path = pathMetadata;
        }
    }

    public String id() {
        return this.id;
    }

    public String host() {
        return this.address;
    }

    public int port() {
        return this.service.getPort();
    }

    public String scheme() {
        return this.scheme;
    }

    public String basePath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsulService that = (ConsulService)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

