/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.el.spel;

import io.gravitee.el.TemplateContext;
import io.gravitee.el.TemplateEngine;
import io.gravitee.el.spel.SpelTemplateContext;
import io.gravitee.el.spel.TemplateParserContext;
import java.util.regex.Pattern;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SpelTemplateEngine
implements TemplateEngine {
    private static final String EXPRESSION_REGEX = "\\{([^#|T|(])";
    private static final Pattern EXPRESSION_REGEX_PATTERN = Pattern.compile("\\{([^#|T|(])");
    private static final String EXPRESSION_REGEX_SUBSTITUTE = "{'{'}$1";
    private static final ParserContext PARSER_CONTEXT = new TemplateParserContext();
    private final SpelTemplateContext templateContext = new SpelTemplateContext();

    @Override
    public String convert(String expression) {
        return this.getValue(expression, String.class);
    }

    private Expression parseExpression(String expression) {
        return new SpelExpressionParser().parseExpression(EXPRESSION_REGEX_PATTERN.matcher(expression).replaceAll(EXPRESSION_REGEX_SUBSTITUTE), PARSER_CONTEXT);
    }

    private <T> T getValue(Expression expression, Class<T> clazz) {
        return (T)expression.getValue(this.templateContext.getContext(), clazz);
    }

    @Override
    public <T> T getValue(String expression, Class<T> clazz) {
        return this.getValue(this.parseExpression(expression), clazz);
    }

    @Override
    public TemplateContext getTemplateContext() {
        return this.templateContext;
    }
}

