/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.el.spel;

import io.gravitee.el.TemplateContext;
import io.gravitee.el.TemplateEngine;
import io.gravitee.el.exceptions.ExpressionEvaluationException;
import io.gravitee.el.spel.TemplateParserContext;
import io.gravitee.el.spel.context.SpelTemplateContext;
import java.util.regex.Pattern;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.SpelCompilerMode;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class SpelTemplateEngine
implements TemplateEngine {
    private static final String EXPRESSION_REGEX = "\\{([^#|T|(])";
    private static final Pattern EXPRESSION_REGEX_PATTERN = Pattern.compile("\\{([^#|T|(])");
    private static final String EXPRESSION_REGEX_SUBSTITUTE = "{'{'}$1";
    private static final ParserContext PARSER_CONTEXT = new TemplateParserContext();
    private static final SpelExpressionParser EXPRESSION_PARSER = new SpelExpressionParser(new SpelParserConfiguration(SpelCompilerMode.MIXED, null));
    private final SpelTemplateContext templateContext = new SpelTemplateContext();

    @Override
    public String convert(String expression) {
        return this.getValue(expression, String.class);
    }

    private Expression parseExpression(String expression) {
        return EXPRESSION_PARSER.parseExpression(EXPRESSION_REGEX_PATTERN.matcher(expression).replaceAll(EXPRESSION_REGEX_SUBSTITUTE), PARSER_CONTEXT);
    }

    private <T> T getValue(Expression expression, Class<T> clazz) {
        try {
            return (T)expression.getValue(this.templateContext.getContext(), clazz);
        }
        catch (SpelEvaluationException spelEvaluationException) {
            throw new ExpressionEvaluationException(expression.getExpressionString(), spelEvaluationException);
        }
    }

    @Override
    public <T> T getValue(String expression, Class<T> clazz) {
        return this.getValue(this.parseExpression(expression), clazz);
    }

    @Override
    public TemplateContext getTemplateContext() {
        return this.templateContext;
    }
}

