/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.el.spel.context;

import io.gravitee.common.util.EnvironmentUtils;
import io.gravitee.el.spel.SpelTemplateEngine;
import io.gravitee.el.spel.context.SpelTemplateContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class SecuredResolver {
    private static final Logger logger = LoggerFactory.getLogger(SecuredResolver.class);
    private static final Method[] EMPTY = new Method[0];
    public static final String WHITELIST_MODE = "append";
    public static final String EL_WHITELIST_MODE_KEY = "el.whitelist.mode";
    public static final String EL_WHITELIST_LIST_KEY = "el.whitelist.list";
    public static final String WHITELIST_METHOD_PREFIX = "method ";
    public static final String WHITELIST_CLASS_PREFIX = "class ";
    static final String WHITELIST_CONSTRUCTOR_PREFIX = "new ";
    private static SecuredResolver INSTANCE;
    private static final Map<Class<?>, Method[]> methodsByType;
    private static final Map<Class<?>, Method[]> methodsByTypeAndSuperTypes;
    private static final Set<Constructor> allConstructors;

    public static void initialize(@Nullable Environment environment) {
        SecuredResolver.loadWhitelistMethods(environment);
        SecuredResolver.getInstance();
    }

    static SecuredResolver getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SecuredResolver();
        }
        return INSTANCE;
    }

    private SecuredResolver() {
    }

    protected Method[] getMethods(Class<?> type) {
        if (methodsByTypeAndSuperTypes.containsKey(type)) {
            return methodsByTypeAndSuperTypes.get(type);
        }
        Method[] methods = methodsByType.getOrDefault(type, EMPTY);
        if (type.getSuperclass() != null) {
            methods = (Method[])Stream.concat(Arrays.stream(methods), Arrays.stream(this.getMethods(type.getSuperclass()))).toArray(Method[]::new);
        }
        for (Class<?> anInterface : type.getInterfaces()) {
            methods = (Method[])Stream.concat(Arrays.stream(methods), Arrays.stream(this.getMethods(anInterface))).toArray(Method[]::new);
        }
        methodsByTypeAndSuperTypes.put(type, methods);
        return methods;
    }

    protected boolean isConstructorAllowed(Constructor<?> constructor) {
        return allConstructors.contains(constructor);
    }

    private static void loadWhitelistMethods(Environment environment) {
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList constructors = new ArrayList();
        boolean loadBuiltInWhitelist = true;
        if (environment != null) {
            loadBuiltInWhitelist = WHITELIST_MODE.equals(environment.getProperty(EL_WHITELIST_MODE_KEY, WHITELIST_MODE));
            Collection configWhitelist = EnvironmentUtils.getPropertiesStartingWith((ConfigurableEnvironment)((ConfigurableEnvironment)environment), (String)EL_WHITELIST_LIST_KEY).values();
            for (String declaration : configWhitelist) {
                SecuredResolver.parseDeclaration(String.valueOf(declaration), methods, constructors);
            }
        }
        if (loadBuiltInWhitelist) {
            InputStream input = SpelTemplateEngine.class.getResourceAsStream("/whitelist");
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            try {
                String declaration;
                while ((declaration = reader.readLine()) != null) {
                    SecuredResolver.parseDeclaration(declaration, methods, constructors);
                }
            }
            catch (IOException ioe) {
                logger.error("Unable to read EL built-in whitelist", (Throwable)ioe);
            }
        }
        methodsByType.clear();
        methodsByType.putAll(methods.stream().collect(Collectors.groupingBy(Method::getDeclaringClass)).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((List)entry.getValue()).toArray(EMPTY))));
        methodsByTypeAndSuperTypes.clear();
        allConstructors.addAll(constructors);
    }

    private static void parseDeclaration(String declaration, List<Method> methods, List<Constructor<?>> constructors) {
        try {
            if (declaration.startsWith(WHITELIST_METHOD_PREFIX)) {
                methods.add(SecuredResolver.parseMethod(declaration));
            } else if (declaration.startsWith(WHITELIST_CONSTRUCTOR_PREFIX)) {
                constructors.add(SecuredResolver.parseConstructor(declaration));
            } else if (declaration.startsWith(WHITELIST_CLASS_PREFIX)) {
                methods.addAll(SecuredResolver.parseAllMethods(declaration));
                constructors.addAll(SecuredResolver.parseAllConstructors(declaration));
            }
        }
        catch (Exception e) {
            logger.warn("The EL whitelisted declaration [{}] cannot be loaded. Message is [{}]", (Object)declaration, (Object)e.toString());
        }
    }

    private static Method parseMethod(String declaration) throws Exception {
        String[] split = declaration.split(" ");
        String clazzName = split[1];
        String methodName = split[2];
        String[] methodArgs = new String[]{};
        if (split.length > 3) {
            methodArgs = Arrays.copyOfRange(split, 3, split.length);
        }
        Class[] argumentClasses = new Class[methodArgs.length];
        for (int i = 0; i < methodArgs.length; ++i) {
            argumentClasses[i] = ClassUtils.forName((String)methodArgs[i], (ClassLoader)SpelTemplateContext.class.getClassLoader());
        }
        Class clazz = ClassUtils.forName((String)clazzName, (ClassLoader)SpelTemplateContext.class.getClassLoader());
        return clazz.getDeclaredMethod(methodName, argumentClasses);
    }

    private static List<Method> parseAllMethods(String declaration) throws Exception {
        String[] split = declaration.split(" ");
        String clazzName = split[1];
        Class clazz = ClassUtils.forName((String)clazzName, (ClassLoader)SpelTemplateContext.class.getClassLoader());
        return Arrays.asList(clazz.getDeclaredMethods());
    }

    private static Constructor parseConstructor(String declaration) throws Exception {
        String[] split = declaration.split(" ");
        String clazzName = split[1];
        String[] methodArgs = new String[]{};
        if (split.length > 2) {
            methodArgs = Arrays.copyOfRange(split, 2, split.length);
        }
        Class[] argumentClasses = new Class[methodArgs.length];
        for (int i = 0; i < methodArgs.length; ++i) {
            argumentClasses[i] = ClassUtils.forName((String)methodArgs[i], (ClassLoader)SecuredResolver.class.getClassLoader());
        }
        Class clazz = ClassUtils.forName((String)clazzName, (ClassLoader)SecuredResolver.class.getClassLoader());
        return clazz.getDeclaredConstructor(argumentClasses);
    }

    private static List<Constructor<?>> parseAllConstructors(String declaration) throws Exception {
        String[] split = declaration.split(" ");
        String clazzName = split[1];
        Class clazz = ClassUtils.forName((String)clazzName, (ClassLoader)SecuredResolver.class.getClassLoader());
        return Arrays.asList(clazz.getDeclaredConstructors());
    }

    static {
        methodsByType = new ConcurrentHashMap();
        methodsByTypeAndSuperTypes = new ConcurrentHashMap();
        allConstructors = ConcurrentHashMap.newKeySet();
    }
}

