/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.maven.plugins.json.schema.generator.mojo;

import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import io.gravitee.maven.plugins.json.schema.generator.mojo.Config;
import io.gravitee.maven.plugins.json.schema.generator.mojo.Mapper;
import io.gravitee.maven.plugins.json.schema.generator.mojo.Output;
import io.gravitee.maven.plugins.json.schema.generator.util.Globs;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-json-schemas", requiresDependencyResolution=ResolutionScope.COMPILE, configurator="include-project-dependencies")
public class JSONSchemaGeneratorMojo
extends AbstractMojo {
    @Parameter(property="includes")
    private List<String> includes;
    @Parameter(property="excludes")
    private List<String> excludes;
    @Parameter(property="buildDirectory", defaultValue="${project.build.outputDirectory}")
    private String buildDirectory;
    @Parameter(property="outputDirectory", defaultValue="${project.build.outputDirectory}/schemas")
    private String outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Config config = new Config(new Globs(this.getIncludes(), this.getExcludes()), this.getBuildDirectory(), this.getOutputDirectory(), this.getLog());
        Mapper mapper = new Mapper(config);
        List<JsonSchema> schemas = mapper.generateJsonSchemas();
        Output output = new Output(config);
        output.write(schemas);
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public String getBuildDirectory() {
        return this.buildDirectory;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }
}

