/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.maven.plugins.json.schema.generator.mojo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import io.gravitee.maven.plugins.json.schema.generator.mojo.Config;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.lang3.Validate;

class Output {
    private Config config;
    public static final String WINDOWS_PATH_SEPARATOR = "\\";

    public Output(Config config) {
        this.config = config;
    }

    public void write(List<JsonSchema> schemas) {
        Validate.notNull(schemas, (String)"Unable to write null schemas", (Object[])new Object[0]);
        try {
            Files.createDirectories(Paths.get(this.config.getOutputDirectory(), new String[0]), new FileAttribute[0]);
            this.createJsonFiles(schemas);
        }
        catch (IOException e) {
            this.config.getLogger().error((CharSequence)("Unable to create output directory " + this.config.getOutputDirectory()), (Throwable)e);
        }
    }

    private void createJsonFiles(List<JsonSchema> schemas) {
        for (JsonSchema schema : schemas) {
            this.createJsonFile(schema);
        }
    }

    private void createJsonFile(JsonSchema schema) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            String json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)schema);
            Path outputPath = Paths.get(this.config.getOutputDirectory() + File.separator + schema.getId().replaceAll(":", "_") + ".json", new String[0]);
            Files.write(outputPath, json.getBytes(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            this.config.getLogger().info((CharSequence)("Created JSON Schema: " + outputPath.normalize().toAbsolutePath().toString()));
        }
        catch (JsonProcessingException e) {
            this.config.getLogger().warn((CharSequence)("Unable to display schema " + schema.getId()), (Throwable)e);
        }
        catch (IOException e) {
            this.config.getLogger().warn((CharSequence)("Unable to write Json file for schema " + schema.getId()), (Throwable)e);
        }
    }
}

