/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.maven.plugins.json.schema.generator.util;

import java.io.File;
import org.apache.commons.lang3.Validate;

public class ClassUtils {
    public static final String PACKAGE_SEPARATOR = ".";
    public static final String CLASS_EXTENSION = ".class";
    public static final String WINDOWS_PATH_SEPARATOR = "\\";
    public static final String WINDOWS_PATH_REGEX_STR = "\\\\";

    public static String convertClassPathToClassName(String path, String basePath) {
        Validate.notNull((Object)path, (String)"Unable to convert null path", (Object[])new Object[0]);
        Validate.notNull((Object)basePath, (String)"Unable to convert null base path", (Object[])new Object[0]);
        String className = path.substring(basePath.length(), path.length());
        className = className.startsWith(File.separator) ? className.substring(1) : className;
        return ClassUtils.convertClassPathToClassName(className);
    }

    public static String convertClassPathToClassName(String path) {
        Validate.notNull((Object)path, (String)"Unable to convert null path", (Object[])new Object[0]);
        String className = path.substring(0, path.lastIndexOf(CLASS_EXTENSION));
        className = className.replaceAll("/", PACKAGE_SEPARATOR);
        if (File.separator.equals(WINDOWS_PATH_SEPARATOR)) {
            return className.replaceAll(WINDOWS_PATH_REGEX_STR, PACKAGE_SEPARATOR);
        }
        return className.replaceAll(File.separator, PACKAGE_SEPARATOR);
    }
}

