/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.container;

import io.gravitee.common.component.Lifecycle;
import io.gravitee.common.component.LifecycleComponent;
import io.gravitee.common.service.AbstractService;
import io.gravitee.common.util.ListReverser;
import io.gravitee.common.util.Version;
import io.gravitee.node.api.Node;
import io.gravitee.node.management.http.ManagementService;
import io.gravitee.node.monitoring.handler.NodeMonitoringEventHandler;
import io.gravitee.node.monitoring.healthcheck.NodeHealthCheckService;
import io.gravitee.node.monitoring.infos.NodeInfosService;
import io.gravitee.node.monitoring.monitor.NodeMonitorService;
import io.gravitee.node.plugins.service.ServiceManager;
import io.gravitee.node.reporter.ReporterManager;
import io.gravitee.plugin.core.api.PluginRegistry;
import io.gravitee.plugin.core.internal.PluginEventListener;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractNode
extends AbstractService<Node>
implements Node,
ApplicationContextAware {
    protected final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected ApplicationContext applicationContext;
    private String hostname;

    public AbstractNode() {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            this.LOGGER.warn("Could not get hostname / IP", (Throwable)uhe);
        }
    }

    protected void doStart() throws Exception {
        this.LOGGER.info("{} is now starting...", (Object)this.name());
        long startTime = System.currentTimeMillis();
        List<Class<? extends LifecycleComponent>> components = this.components();
        this.preStartComponents(components);
        this.startComponents(components);
        this.postStartComponents(components);
        long endTime = System.currentTimeMillis();
        String processId = ManagementFactory.getRuntimeMXBean().getName();
        if (processId.contains("@")) {
            processId = processId.split("@")[0];
        }
        this.LOGGER.info("{} id[{}] version[{}] pid[{}] build[{}#{}] jvm[{}/{}/{}] started in {} ms.", new Object[]{this.name(), this.id(), Version.RUNTIME_VERSION.MAJOR_VERSION, processId, Version.RUNTIME_VERSION.BUILD_NUMBER, Version.RUNTIME_VERSION.REVISION, ManagementFactory.getRuntimeMXBean().getVmVendor(), ManagementFactory.getRuntimeMXBean().getVmName(), ManagementFactory.getRuntimeMXBean().getVmVersion(), endTime - startTime});
    }

    protected void doStop() throws Exception {
        this.LOGGER.info("{} is stopping", (Object)this.name());
        List<Class<? extends LifecycleComponent>> components = this.components();
        this.preStopComponents((Iterable<Class<? extends LifecycleComponent>>)new ListReverser(components));
        this.stopComponents((Iterable<Class<? extends LifecycleComponent>>)new ListReverser(components));
        this.postStopComponents((Iterable<Class<? extends LifecycleComponent>>)new ListReverser(components));
        this.LOGGER.info("{} stopped", (Object)this.name());
    }

    public String hostname() {
        return this.hostname;
    }

    public abstract String name();

    public List<Class<? extends LifecycleComponent>> components() {
        ArrayList<Class<? extends LifecycleComponent>> components = new ArrayList<Class<? extends LifecycleComponent>>();
        components.add(PluginEventListener.class);
        components.add(PluginRegistry.class);
        components.add(ServiceManager.class);
        components.add(ManagementService.class);
        components.add(NodeMonitoringEventHandler.class);
        components.add(NodeInfosService.class);
        components.add(NodeHealthCheckService.class);
        components.add(NodeMonitorService.class);
        components.add(ReporterManager.class);
        return components;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private void preStartComponents(Iterable<Class<? extends LifecycleComponent>> components) throws Exception {
        for (Class<? extends LifecycleComponent> componentClass : components) {
            try {
                this.LOGGER.debug("\tPre-starting component: {}", (Object)componentClass.getSimpleName());
                ((LifecycleComponent)this.applicationContext.getBean(componentClass)).preStart();
            }
            catch (Exception e) {
                this.LOGGER.error("An error occurred while pre-starting component {}", componentClass, (Object)e);
                throw e;
            }
        }
    }

    private void startComponents(Iterable<Class<? extends LifecycleComponent>> components) throws Exception {
        for (Class<? extends LifecycleComponent> componentClass : components) {
            try {
                this.LOGGER.info("\tStarting component: {}", (Object)componentClass.getSimpleName());
                ((LifecycleComponent)this.applicationContext.getBean(componentClass)).start();
            }
            catch (Exception e) {
                this.LOGGER.error("An error occurred while starting component {}", componentClass, (Object)e);
                throw e;
            }
        }
    }

    private void postStartComponents(Iterable<Class<? extends LifecycleComponent>> components) throws Exception {
        for (Class<? extends LifecycleComponent> componentClass : components) {
            try {
                this.LOGGER.debug("\tPost-starting component: {}", (Object)componentClass.getSimpleName());
                ((LifecycleComponent)this.applicationContext.getBean(componentClass)).postStart();
            }
            catch (Exception e) {
                this.LOGGER.error("An error occurred while post-starting component {}", componentClass, (Object)e);
                throw e;
            }
        }
    }

    private void preStopComponents(Iterable<Class<? extends LifecycleComponent>> components) {
        for (Class<? extends LifecycleComponent> componentClass : components) {
            try {
                LifecycleComponent lifecycleComponent = (LifecycleComponent)this.applicationContext.getBean(componentClass);
                if (lifecycleComponent.lifecycleState() != Lifecycle.State.STARTED) continue;
                this.LOGGER.debug("\tPre-stopping component: {}", (Object)componentClass.getSimpleName());
                lifecycleComponent.preStop();
            }
            catch (Exception e) {
                this.LOGGER.error("An error occurred while pre-stopping component {}", (Object)componentClass.getSimpleName(), (Object)e);
            }
        }
    }

    private void stopComponents(Iterable<Class<? extends LifecycleComponent>> components) {
        for (Class<? extends LifecycleComponent> componentClass : components) {
            try {
                LifecycleComponent lifecycleComponent = (LifecycleComponent)this.applicationContext.getBean(componentClass);
                if (lifecycleComponent.lifecycleState() != Lifecycle.State.STARTED) continue;
                this.LOGGER.info("\tStopping component: {}", (Object)componentClass.getSimpleName());
                lifecycleComponent.stop();
            }
            catch (Exception e) {
                this.LOGGER.error("An error occurred while stopping component {}", (Object)componentClass.getSimpleName(), (Object)e);
            }
        }
    }

    private void postStopComponents(Iterable<Class<? extends LifecycleComponent>> components) throws Exception {
        for (Class<? extends LifecycleComponent> componentClass : components) {
            try {
                this.LOGGER.debug("\tPost-stopping component: {}", (Object)componentClass.getSimpleName());
                ((LifecycleComponent)this.applicationContext.getBean(componentClass)).postStop();
            }
            catch (Exception e) {
                this.LOGGER.error("An error occurred while post-stopping component {}", componentClass, (Object)e);
                throw e;
            }
        }
    }
}

