/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.container.spring.env;

import io.gravitee.node.kubernetes.propertyresolver.CloudScheme;
import io.gravitee.node.kubernetes.propertyresolver.PropertyResolver;
import io.gravitee.node.kubernetes.propertyresolver.PropertyResolverFactoriesLoader;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public abstract class AbstractGraviteePropertySource
extends PropertySource<Map<String, Object>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGraviteePropertySource.class);
    private final PropertyResolverFactoriesLoader propertyResolverLoader;

    protected AbstractGraviteePropertySource(String name, Map<String, Object> source, ApplicationContext applicationContext) {
        super(name, source);
        this.propertyResolverLoader = (PropertyResolverFactoriesLoader)applicationContext.getBean(PropertyResolverFactoriesLoader.class);
    }

    public Object getProperty(String name) {
        Assert.notNull((Object)name, (String)"Property name can not be null.");
        Object value = ((Map)this.source).getOrDefault(name, this.getValue(name));
        if (value == null) {
            return null;
        }
        if (this.isCloudBased(value)) {
            for (PropertyResolver propertyResolver : this.propertyResolverLoader.getPropertyResolvers()) {
                if (!propertyResolver.supports(value.toString())) continue;
                Object resolvedValue = propertyResolver.resolve(value.toString()).doOnError(t -> {
                    LOGGER.error("Unable to resolve property {}", (Object)name, t);
                    ((Map)this.source).put(name, null);
                }).blockingGet();
                ((Map)this.source).put(name, resolvedValue);
                this.watchProperty(propertyResolver, name, value);
                break;
            }
        }
        return this.getValue(name);
    }

    protected abstract Object getValue(String var1);

    private boolean isCloudBased(Object value) {
        for (CloudScheme cloudScheme : CloudScheme.values()) {
            if (!value.toString().startsWith(cloudScheme.value())) continue;
            return true;
        }
        return false;
    }

    private void watchProperty(PropertyResolver propertyResolver, String name, Object value) {
        propertyResolver.watch(value.toString()).doOnNext(newValue -> ((Map)this.source).put(name, newValue)).doOnError(t -> LOGGER.error("Unable to update property {}", (Object)name, t)).doOnComplete(() -> this.watchProperty(propertyResolver, name, value)).subscribe();
    }
}

