/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.jetty;

import io.gravitee.common.component.AbstractLifecycleComponent;
import io.gravitee.node.jetty.handler.NoContentOutputErrorHandler;
import io.gravitee.node.jetty.spring.JettyContainerConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Import;

@Import(value={JettyContainerConfiguration.class})
public abstract class JettyHttpServer
extends AbstractLifecycleComponent<JettyHttpServer> {
    private final Logger logger = LoggerFactory.getLogger(JettyHttpServer.class);
    @Autowired
    protected Server server;

    protected abstract void attachHandlers();

    protected void doStart() throws Exception {
        this.attachNoContentHandler();
        this.attachHandlers();
        this.server.setStopAtShutdown(true);
        try {
            this.server.join();
            this.server.start();
            this.logger.info("HTTP Server is now started and listening on port {}", (Object)((ServerConnector)this.server.getConnectors()[0]).getPort());
        }
        catch (InterruptedException ex) {
            this.logger.error("An error occurs while trying to initialize HTTP server", (Throwable)ex);
            throw ex;
        }
    }

    protected void doStop() throws Exception {
        this.server.stop();
    }

    private void attachNoContentHandler() {
        NoContentOutputErrorHandler noContentHandler = new NoContentOutputErrorHandler();
        noContentHandler.setServer(this.server);
        this.server.addBean((Object)noContentHandler);
    }
}

