/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.jetty;

import io.gravitee.node.jetty.JettyHttpConfiguration;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ArrayBlockingQueue;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.AsyncRequestLogWriter;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

public class JettyHttpServerFactory
implements FactoryBean<Server> {
    private static final String KEYSTORE_TYPE_PKCS12 = "pkcs12";
    @Autowired
    private JettyHttpConfiguration jettyHttpConfiguration;

    public Server getObject() {
        QueuedThreadPool threadPool = new QueuedThreadPool(this.jettyHttpConfiguration.getPoolMaxThreads(), this.jettyHttpConfiguration.getPoolMinThreads(), this.jettyHttpConfiguration.getPoolIdleTimeout(), new ArrayBlockingQueue(this.jettyHttpConfiguration.getPoolQueueSize()));
        threadPool.setName("gravitee-listener");
        Server server = new Server((ThreadPool)threadPool);
        server.setDumpAfterStart(false);
        server.setDumpBeforeStop(false);
        server.setStopAtShutdown(true);
        if (this.jettyHttpConfiguration.isJmxEnabled()) {
            MBeanContainer mbContainer = new MBeanContainer(ManagementFactory.getPlatformMBeanServer());
            server.addBean((Object)mbContainer);
        }
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setOutputBufferSize(32768);
        httpConfig.setRequestHeaderSize(8192);
        httpConfig.setResponseHeaderSize(8192);
        httpConfig.setSendServerVersion(false);
        httpConfig.setSendDateHeader(false);
        httpConfig.setRequestCookieCompliance(CookieCompliance.RFC2965);
        httpConfig.setResponseCookieCompliance(CookieCompliance.RFC2965);
        if (this.jettyHttpConfiguration.isSecured()) {
            httpConfig.setSecureScheme("https");
            httpConfig.setSecurePort(this.jettyHttpConfiguration.getHttpPort());
            SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
            if (this.jettyHttpConfiguration.getKeyStorePath() != null) {
                sslContextFactory.setKeyStorePath(this.jettyHttpConfiguration.getKeyStorePath());
                sslContextFactory.setKeyStorePassword(this.jettyHttpConfiguration.getKeyStorePassword());
                if (KEYSTORE_TYPE_PKCS12.equalsIgnoreCase(this.jettyHttpConfiguration.getKeyStoreType())) {
                    sslContextFactory.setKeyStoreType(KEYSTORE_TYPE_PKCS12);
                }
            }
            if (this.jettyHttpConfiguration.getTrustStorePath() != null) {
                sslContextFactory.setTrustStorePath(this.jettyHttpConfiguration.getTrustStorePath());
                sslContextFactory.setTrustStorePassword(this.jettyHttpConfiguration.getTrustStorePassword());
                if (KEYSTORE_TYPE_PKCS12.equalsIgnoreCase(this.jettyHttpConfiguration.getTrustStoreType())) {
                    sslContextFactory.setTrustStoreType(KEYSTORE_TYPE_PKCS12);
                }
            }
            HttpConfiguration httpsConfig = new HttpConfiguration(httpConfig);
            httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            ServerConnector https = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
            https.setHost(this.jettyHttpConfiguration.getHttpHost());
            https.setPort(this.jettyHttpConfiguration.getHttpPort());
            server.addConnector((Connector)https);
        } else {
            ServerConnector http = new ServerConnector(server, this.jettyHttpConfiguration.getAcceptors(), this.jettyHttpConfiguration.getSelectors(), new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
            http.setHost(this.jettyHttpConfiguration.getHttpHost());
            http.setPort(this.jettyHttpConfiguration.getHttpPort());
            http.setIdleTimeout((long)this.jettyHttpConfiguration.getIdleTimeout());
            server.addConnector((Connector)http);
        }
        if (this.jettyHttpConfiguration.isStatisticsEnabled()) {
            StatisticsHandler stats = new StatisticsHandler();
            stats.setHandler(server.getHandler());
            server.setHandler((Handler)stats);
        }
        if (this.jettyHttpConfiguration.isAccessLogEnabled()) {
            AsyncRequestLogWriter requestLogWriter = new AsyncRequestLogWriter(this.jettyHttpConfiguration.getAccessLogPath());
            requestLogWriter.setRetainDays(90);
            requestLogWriter.setTimeZone("GMT");
            CustomRequestLog requestLog = new CustomRequestLog((RequestLog.Writer)requestLogWriter, "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"");
            server.setRequestLog((RequestLog)requestLog);
        }
        return server;
    }

    public Class<?> getObjectType() {
        return Server.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

