/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.jetty.healthcheck;

import io.gravitee.node.api.healthcheck.Probe;
import io.gravitee.node.api.healthcheck.Result;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import java.util.concurrent.CompletionStage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class JettyHttpServerProbe
implements Probe {
    @Value(value="${jetty.port:8093}")
    private int port;
    @Value(value="${jetty.host:localhost}")
    private String host;
    @Autowired
    private Vertx vertx;

    public String id() {
        return "jetty-http-server";
    }

    public CompletionStage<Result> check() {
        Promise promise = Promise.promise();
        NetClientOptions options = new NetClientOptions().setConnectTimeout(500);
        NetClient client = this.vertx.createNetClient(options);
        client.connect(this.port, this.host, res -> {
            if (res.succeeded()) {
                promise.complete((Object)Result.healthy());
            } else {
                promise.complete((Object)Result.unhealthy((Throwable)res.cause()));
            }
            client.close();
        });
        return promise.future().toCompletionStage();
    }
}

