/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.kubernetes.keystoreloader;

import io.gravitee.common.util.KeyStoreUtils;
import io.gravitee.kubernetes.client.KubernetesClient;
import io.gravitee.kubernetes.client.api.ResourceQuery;
import io.gravitee.node.api.certificate.KeyStoreBundle;
import io.gravitee.node.api.certificate.KeyStoreLoader;
import io.gravitee.node.api.certificate.KeyStoreLoaderOptions;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractKubernetesKeyStoreLoader<T>
implements KeyStoreLoader {
    private static final Logger logger = LoggerFactory.getLogger(AbstractKubernetesKeyStoreLoader.class);
    protected static final int RETRY_DELAY_MILLIS = 10000;
    protected final KeyStoreLoaderOptions options;
    protected final KubernetesClient kubernetesClient;
    protected final List<Consumer<KeyStoreBundle>> listeners;
    protected final Map<String, KeyStore> keyStoresByLocation;
    protected final Map<String, ResourceQuery<T>> resources = new HashMap<String, ResourceQuery<T>>();
    protected KeyStoreBundle keyStoreBundle;
    private Disposable disposable;

    public AbstractKubernetesKeyStoreLoader(KeyStoreLoaderOptions options, KubernetesClient kubernetesClient) {
        this.options = options;
        this.kubernetesClient = kubernetesClient;
        this.listeners = new ArrayList<Consumer<KeyStoreBundle>>();
        this.keyStoresByLocation = new ConcurrentHashMap<String, KeyStore>();
    }

    public void start() {
        try {
            this.init().doOnComplete(() -> {
                if (this.options.isWatch()) {
                    this.startWatch();
                }
            }).blockingAwait();
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("An error occurred when trying to init certificates.", throwable);
        }
    }

    protected void startWatch() {
        this.disposable = this.watch().observeOn(Schedulers.computation()).flatMapCompletable(t -> this.loadKeyStore(t).andThen((CompletableSource)Completable.fromRunnable(this::refreshKeyStoreBundle))).doOnError(throwable -> logger.error("An error occurred during keystore refresh. Restarting watch.", throwable)).retry().subscribe();
    }

    public void stop() {
        if (this.disposable != null && !this.disposable.isDisposed()) {
            this.disposable.dispose();
        }
    }

    protected abstract Flowable<T> watch();

    protected abstract Completable init();

    protected abstract Completable loadKeyStore(T var1);

    public void addListener(Consumer<KeyStoreBundle> listener) {
        this.listeners.add(listener);
    }

    protected void refreshKeyStoreBundle() {
        KeyStore keyStore = KeyStoreUtils.merge(new ArrayList<KeyStore>(this.keyStoresByLocation.values()), (String)this.options.getKeyStorePassword());
        this.keyStoreBundle = new KeyStoreBundle(keyStore, this.options.getKeyStorePassword(), this.options.getDefaultAlias());
        this.notifyListeners();
    }

    protected void notifyListeners() {
        this.listeners.forEach(consumer -> consumer.accept(this.keyStoreBundle));
    }
}

