/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.kubernetes.keystoreloader;

import io.gravitee.kubernetes.client.KubernetesClient;
import io.gravitee.node.api.certificate.KeyStoreLoader;
import io.gravitee.node.api.certificate.KeyStoreLoaderFactory;
import io.gravitee.node.api.certificate.KeyStoreLoaderOptions;
import io.gravitee.node.kubernetes.keystoreloader.KubernetesConfigMapKeyStoreLoader;
import io.gravitee.node.kubernetes.keystoreloader.KubernetesSecretKeyStoreLoader;

public class KubernetesKeyStoreLoaderFactory
implements KeyStoreLoaderFactory {
    private final KubernetesClient client;

    public KubernetesKeyStoreLoaderFactory(KubernetesClient client) {
        this.client = client;
    }

    public boolean canHandle(KeyStoreLoaderOptions options) {
        return KubernetesConfigMapKeyStoreLoader.canHandle(options) || KubernetesSecretKeyStoreLoader.canHandle(options);
    }

    public KeyStoreLoader create(KeyStoreLoaderOptions options) {
        if (KubernetesConfigMapKeyStoreLoader.canHandle(options)) {
            return new KubernetesConfigMapKeyStoreLoader(options, this.client);
        }
        if (KubernetesSecretKeyStoreLoader.canHandle(options)) {
            return new KubernetesSecretKeyStoreLoader(options, this.client);
        }
        throw new IllegalArgumentException("Cannot found appropriate KubernetesKeyStoreLoaderFactory.");
    }
}

